/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.DirectoryRenameHandlerBase;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class DirectoryAsPackageRenameHandlerBase<T extends PsiDirectoryContainer>
extends DirectoryRenameHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.DirectoryAsPackageRenameHandler");

    protected abstract VirtualFile[] occursInPackagePrefixes(T var1);

    protected abstract boolean isIdentifier(String var1, Project var2);

    protected abstract String getQualifiedName(T var1);

    @Nullable
    protected abstract T getPackage(PsiDirectory var1);

    protected abstract BaseRefactoringProcessor createProcessor(String var1, Project var2, PsiDirectory[] var3, boolean var4, boolean var5);

    @Override
    protected boolean isSuitableDirectory(PsiDirectory directory) {
        return this.getPackage(directory) != null;
    }

    @Override
    protected void doRename(PsiElement element, Project project, PsiElement nameSuggestionContext, Editor editor) {
        String qualifiedName;
        PsiDirectory psiDirectory = (PsiDirectory)element;
        T aPackage = this.getPackage(psiDirectory);
        String string = qualifiedName = aPackage != null ? this.getQualifiedName(aPackage) : "";
        if (aPackage == null || qualifiedName.length() == 0 || !this.isIdentifier(psiDirectory.getName(), project)) {
            PsiElementRenameHandler.rename(element, project, nameSuggestionContext, editor);
        } else {
            PsiDirectory[] directories = aPackage.getDirectories();
            VirtualFile[] virtualFiles = this.occursInPackagePrefixes(aPackage);
            int nonGeneratedCount = 0;
            for (PsiDirectory dir : directories) {
                VirtualFile virtualFile = dir.getVirtualFile();
                if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)dir.getProject())) continue;
                ++nonGeneratedCount;
            }
            if (virtualFiles.length == 0 && nonGeneratedCount <= 1) {
                PsiElementRenameHandler.rename(aPackage, project, nameSuggestionContext, editor);
            } else {
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                boolean inLib = false;
                for (PsiDirectory directory : directories) {
                    inLib |= !projectFileIndex.isInContent(directory.getVirtualFile());
                }
                PsiDirectory[] projectDirectories = aPackage.getDirectories(GlobalSearchScope.projectScope((Project)project));
                if (inLib) {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory);
                    LOG.assertTrue(module != null);
                    PsiDirectory[] moduleDirs = null;
                    if (nameSuggestionContext instanceof PsiPackageBase && (moduleDirs = aPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module))).length <= 1) {
                        moduleDirs = null;
                    }
                    String promptMessage = "Package '" + aPackage.getName() + "' contains directories in libraries which cannot be renamed. Do you want to rename " + (moduleDirs == null ? "current directory" : "current module directories");
                    if (projectDirectories.length > 0) {
                        PsiDirectory[] psiDirectoryArray;
                        int ret = Messages.showYesNoCancelDialog((Project)project, (String)(promptMessage + " or all directories in project?"), (String)RefactoringBundle.message((String)"warning.title"), (String)RefactoringBundle.message((String)"rename.current.directory"), (String)RefactoringBundle.message((String)"rename.directories"), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
                        if (ret == 2) {
                            return;
                        }
                        if (ret == 0) {
                            if (moduleDirs == null) {
                                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                                psiDirectoryArray = psiDirectoryArray2;
                                psiDirectoryArray2[0] = psiDirectory;
                            } else {
                                psiDirectoryArray = moduleDirs;
                            }
                        } else {
                            psiDirectoryArray = projectDirectories;
                        }
                        this.renameDirs(project, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectoryArray);
                    } else if (Messages.showOkCancelDialog((Project)project, (String)(promptMessage + "?"), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon()) == 0) {
                        this.renameDirs(project, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectory);
                    }
                } else {
                    StringBuffer message = new StringBuffer();
                    RenameUtil.buildPackagePrefixChangedMessage(virtualFiles, message, qualifiedName);
                    DirectoryAsPackageRenameHandlerBase.buildMultipleDirectoriesInPackageMessage(message, this.getQualifiedName(aPackage), directories);
                    message.append(RefactoringBundle.message((String)"directories.and.all.references.to.package.will.be.renamed", (Object[])new Object[]{psiDirectory.getVirtualFile().getPresentableUrl()}));
                    int ret = Messages.showYesNoCancelDialog((Project)project, (String)message.toString(), (String)RefactoringBundle.message((String)"warning.title"), (String)RefactoringBundle.message((String)"rename.package.button.text"), (String)RefactoringBundle.message((String)"rename.directory.button.text"), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
                    if (ret == 0) {
                        PsiElementRenameHandler.rename(aPackage, project, nameSuggestionContext, editor);
                    } else if (ret == 1) {
                        this.renameDirs(project, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectory);
                    }
                }
            }
        }
    }

    private void renameDirs(Project project, PsiElement nameSuggestionContext, Editor editor, PsiDirectory contextDirectory, T aPackage, PsiDirectory ... dirsToRename) {
        RenameDialog dialog2 = new RenameDialog(project, (PsiElement)contextDirectory, nameSuggestionContext, editor, (PsiDirectoryContainer)aPackage, project, dirsToRename){
            final /* synthetic */ PsiDirectoryContainer val$aPackage;
            final /* synthetic */ Project val$project;
            final /* synthetic */ PsiDirectory[] val$dirsToRename;
            {
                this.val$aPackage = psiDirectoryContainer;
                this.val$project = project2;
                this.val$dirsToRename = psiDirectoryArray;
                super(project, psiElement, nameSuggestionContext, editor);
            }

            @Override
            protected void doAction() {
                String newQName = StringUtil.getQualifiedName((String)StringUtil.getPackageName((String)DirectoryAsPackageRenameHandlerBase.this.getQualifiedName(this.val$aPackage)), (String)this.getNewName());
                BaseRefactoringProcessor moveProcessor = DirectoryAsPackageRenameHandlerBase.this.createProcessor(newQName, this.val$project, this.val$dirsToRename, this.isSearchInComments(), this.isSearchInNonJavaFiles());
                this.invokeRefactoring(moveProcessor);
            }
        };
        dialog2.show();
    }

    public static void buildMultipleDirectoriesInPackageMessage(StringBuffer message, String packageQname, PsiDirectory[] directories) {
        message.append(RefactoringBundle.message((String)"multiple.directories.correspond.to.package"));
        message.append(packageQname);
        message.append(":\n\n");
        ArrayList<PsiDirectory> generated = new ArrayList<PsiDirectory>();
        ArrayList<PsiDirectory> source = new ArrayList<PsiDirectory>();
        for (PsiDirectory directory2 : directories) {
            VirtualFile virtualFile = directory2.getVirtualFile();
            if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)directory2.getProject())) {
                generated.add(directory2);
                continue;
            }
            source.add(directory2);
        }
        Function directoryPresentation = directory -> directory.getVirtualFile().getPresentableUrl();
        message.append(StringUtil.join(source, (Function)directoryPresentation, (String)"\n"));
        if (!generated.isEmpty()) {
            message.append("\n\nalso generated:\n");
            message.append(StringUtil.join(generated, (Function)directoryPresentation, (String)"\n"));
        }
    }
}

