/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RelatedFilesRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelatedFilesRenamerFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(@NotNull PsiElement element) {
        return element instanceof PsiFile && ((PsiFile)element).getVirtualFile() != null && !NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), ((PsiFile)element).getVirtualFile()).isEmpty();
    }

    @Override
    @Nullable
    public String getOptionName() {
        return "Rename related files (with the same name)";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    @NotNull
    public AutomaticRenamer createRenamer(@NotNull PsiElement element, @NotNull String newName, @NotNull Collection<UsageInfo> usages) {
        return new RelatedFilesRenamer((PsiFile)element, newName);
    }
}

