/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameInputValidatorRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameDialog
extends RefactoringDialog {
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"rename.title");
    private SuggestedNameInfo mySuggestedNameInfo;
    private JLabel myNameLabel;
    private NameSuggestionsField myNameSuggestionsField;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurrences;
    private final JLabel myNewNamePrefix = new JLabel("");
    private final String myHelpID;
    private final PsiElement myPsiElement;
    private final PsiElement myNameSuggestionContext;
    private final Editor myEditor;
    private NameSuggestionsField.DataChanged myNameChangedListener;
    private final Map<AutomaticRenamerFactory, JCheckBox> myAutoRenamerFactories = new HashMap<AutomaticRenamerFactory, JCheckBox>();
    private String myOldName;

    public RenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor) {
        super(project, true);
        PsiUtilCore.ensureValid((PsiElement)psiElement);
        this.myPsiElement = psiElement;
        this.myNameSuggestionContext = nameSuggestionContext;
        this.myEditor = editor;
        this.setTitle(REFACTORING_NAME);
        this.createNewNameComponent();
        this.init();
        this.myNameLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)XmlTagUtilBase.escapeString((String)this.getLabelText(), (boolean)false)));
        boolean toSearchInComments = this.isToSearchInCommentsForRename();
        this.myCbSearchInComments.setSelected(toSearchInComments);
        if (this.myCbSearchTextOccurrences.isEnabled()) {
            boolean toSearchForTextOccurrences = this.isToSearchForTextOccurrencesForRename();
            this.myCbSearchTextOccurrences.setSelected(toSearchForTextOccurrences);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.validateButtons();
        }
        this.myHelpID = RenamePsiElementProcessor.forElement(psiElement).getHelpID(psiElement);
    }

    public static void showRenameDialog(DataContext dataContext, RenameDialog dialog2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String name = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
            dialog2.performRename(name);
            dialog2.close(0);
        } else {
            dialog2.show();
        }
    }

    @NotNull
    protected String getLabelText() {
        return RefactoringBundle.message((String)"rename.0.and.its.usages.to", (Object[])new Object[]{this.getFullName()});
    }

    @NotNull
    public PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @Override
    protected boolean hasPreviewButton() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).showRenamePreviewButton(this.myPsiElement);
    }

    protected void dispose() {
        this.myNameSuggestionsField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    protected boolean isToSearchForTextOccurrencesForRename() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).isToSearchForTextOccurrences(this.myPsiElement);
    }

    protected boolean isToSearchInCommentsForRename() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).isToSearchInComments(this.myPsiElement);
    }

    protected String getFullName() {
        String name = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myPsiElement);
        String type = UsageViewUtil.getType(this.myPsiElement);
        return StringUtil.isEmpty((String)name) ? type : type + " '" + name + "'";
    }

    protected void createNewNameComponent() {
        String[] suggestedNames = this.getSuggestedNames();
        this.myOldName = UsageViewUtil.getShortName(this.myPsiElement);
        this.myNameSuggestionsField = new NameSuggestionsField(suggestedNames, this.myProject, (FileType)FileTypes.PLAIN_TEXT, this.myEditor){

            @Override
            protected boolean shouldSelectAll() {
                return RenameDialog.this.myEditor == null || RenameDialog.this.myEditor.getSettings().isPreselectRename();
            }
        };
        if (this.myPsiElement instanceof PsiFile && this.myEditor == null) {
            this.myNameSuggestionsField.selectNameWithoutExtension();
        }
        this.myNameChangedListener = () -> this.processNewNameChanged();
        this.myNameSuggestionsField.addDataChangedListener(this.myNameChangedListener);
    }

    protected void preselectExtension(int start2, int end) {
        this.myNameSuggestionsField.select(start2, end);
    }

    protected void processNewNameChanged() {
        this.validateButtons();
    }

    public String[] getSuggestedNames() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        String initialName = VariableInplaceRenameHandler.getInitialName();
        if (initialName != null) {
            result2.add(initialName);
        }
        result2.add(UsageViewUtil.getShortName(this.myPsiElement));
        for (NameSuggestionProvider provider : NameSuggestionProvider.EP_NAME.getExtensionList()) {
            SuggestedNameInfo info = provider.getSuggestedNames(this.myPsiElement, this.myNameSuggestionContext, result2);
            if (info == null) continue;
            this.mySuggestedNameInfo = info;
            if (!(provider instanceof PreferrableNameSuggestionProvider) || ((PreferrableNameSuggestionProvider)provider).shouldCheckOthers()) continue;
            break;
        }
        return ArrayUtil.toStringArray(result2);
    }

    @NotNull
    public String getNewName() {
        return this.myNameSuggestionsField.getEnteredName().trim();
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this.myCbSearchTextOccurrences.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField.getFocusableComponent();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        this.myNameLabel = new JLabel();
        panel2.add((Component)this.myNameLabel, gbConstraints);
        gbConstraints.insets = JBUI.insets((int)0, (int)0, (int)4, (int)(StringUtil.isEmpty((String)this.myNewNamePrefix.getText()) ? 0 : 1));
        gbConstraints.gridwidth = 1;
        gbConstraints.fill = 0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.anchor = 17;
        panel2.add((Component)this.myNewNamePrefix, gbConstraints);
        gbConstraints.insets = JBUI.insetsBottom((int)8);
        gbConstraints.gridwidth = 2;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.weighty = 1.0;
        panel2.add((Component)this.myNameSuggestionsField.getComponent(), gbConstraints);
        this.createCheckboxes(panel2, gbConstraints);
        return panel2;
    }

    protected void createCheckboxes(JPanel panel2, GridBagConstraints gbConstraints) {
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbSearchInComments = new NonFocusableCheckBox();
        this.myCbSearchInComments.setText(RefactoringBundle.getSearchInCommentsAndStringsText());
        this.myCbSearchInComments.setSelected(true);
        panel2.add((Component)this.myCbSearchInComments, gbConstraints);
        gbConstraints.insets = JBUI.insets((int)0, (int)10, (int)4, (int)0);
        gbConstraints.gridwidth = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbSearchTextOccurrences = new NonFocusableCheckBox();
        this.myCbSearchTextOccurrences.setText(RefactoringBundle.getSearchForTextOccurrencesText());
        this.myCbSearchTextOccurrences.setSelected(true);
        panel2.add((Component)this.myCbSearchTextOccurrences, gbConstraints);
        if (!TextOccurrencesUtil.isSearchTextOccurencesEnabled(this.myPsiElement)) {
            this.myCbSearchTextOccurrences.setEnabled(false);
            this.myCbSearchTextOccurrences.setSelected(false);
            this.myCbSearchTextOccurrences.setVisible(false);
        }
        for (AutomaticRenamerFactory factory : AutomaticRenamerFactory.EP_NAME.getExtensionList()) {
            if (!factory.isApplicable(this.myPsiElement) || factory.getOptionName() == null) continue;
            gbConstraints.gridwidth = this.myAutoRenamerFactories.size() % 2 == 0 ? 1 : 0;
            gbConstraints.gridx = this.myAutoRenamerFactories.size() % 2;
            gbConstraints.insets = gbConstraints.gridx == 0 ? JBUI.insetsBottom((int)4) : JBUI.insets((int)0, (int)10, (int)4, (int)0);
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            NonFocusableCheckBox checkBox2 = new NonFocusableCheckBox();
            checkBox2.setText(factory.getOptionName());
            checkBox2.setSelected(factory.isEnabled());
            panel2.add((Component)checkBox2, gbConstraints);
            this.myAutoRenamerFactories.put(factory, (JCheckBox)checkBox2);
        }
    }

    protected String getHelpId() {
        return this.myHelpID;
    }

    @Override
    protected void doAction() {
        PsiUtilCore.ensureValid((PsiElement)this.myPsiElement);
        String newName = this.getNewName();
        this.performRename(newName);
    }

    public void performRename(String newName) {
        RenamePsiElementProcessor elementProcessor = RenamePsiElementProcessor.forElement(this.myPsiElement);
        elementProcessor.setToSearchInComments(this.myPsiElement, this.isSearchInComments());
        if (this.myCbSearchTextOccurrences.isEnabled()) {
            elementProcessor.setToSearchForTextOccurrences(this.myPsiElement, this.isSearchInNonJavaFiles());
        }
        if (this.mySuggestedNameInfo != null) {
            this.mySuggestedNameInfo.nameChosen(newName);
        }
        RenameProcessor processor2 = this.createRenameProcessor(newName);
        for (Map.Entry<AutomaticRenamerFactory, JCheckBox> e : this.myAutoRenamerFactories.entrySet()) {
            e.getKey().setEnabled(e.getValue().isSelected());
            if (!e.getValue().isSelected()) continue;
            processor2.addRenamerFactory(e.getKey());
        }
        this.invokeRefactoring(processor2);
    }

    protected RenameProcessor createRenameProcessor(String newName) {
        return new RenameProcessor(this.getProject(), this.myPsiElement, newName, this.isSearchInComments(), this.isSearchInNonJavaFiles());
    }

    @Override
    protected void canRun() throws ConfigurationException {
        if (Comparing.strEqual((String)this.getNewName(), (String)this.myOldName)) {
            throw new ConfigurationException(null);
        }
        if (!this.areButtonsValid()) {
            throw new ConfigurationException("'" + this.getNewName() + "' is not a valid identifier");
        }
        Function inputValidator = RenameInputValidatorRegistry.getInputErrorValidator((PsiElement)this.myPsiElement);
        if (inputValidator != null) {
            this.setErrorText((String)inputValidator.fun((Object)this.getNewName()));
        }
    }

    @Override
    protected boolean areButtonsValid() {
        String newName = this.getNewName();
        return RenameUtil.isValidName(this.myProject, this.myPsiElement, newName);
    }

    protected NameSuggestionsField getNameSuggestionsField() {
        return this.myNameSuggestionsField;
    }

    public JCheckBox getCbSearchInComments() {
        return this.myCbSearchInComments;
    }
}

