/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class RenameChooser {
    @NonNls
    private static final String CODE_OCCURRENCES = "Rename code occurrences";
    @NonNls
    private static final String ALL_OCCURRENCES = "Rename all occurrences";
    private final Set<RangeHighlighter> myRangeHighlighters = new HashSet<RangeHighlighter>();
    private final Editor myEditor;
    private final TextAttributes myAttributes;

    RenameChooser(Editor editor) {
        this.myEditor = editor;
        this.myAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    protected abstract void runRenameTemplate(Collection<Pair<PsiElement, TextRange>> var1);

    public void showChooser(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.runRenameTemplate(RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE ? stringUsages : new ArrayList());
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])new String[]{CODE_OCCURRENCES, ALL_OCCURRENCES})).setItemSelectedCallback(selectedValue -> {
            if (selectedValue == null) {
                return;
            }
            this.dropHighlighters();
            MarkupModel markupModel = this.myEditor.getMarkupModel();
            if (selectedValue.equals(ALL_OCCURRENCES)) {
                for (Pair pair : stringUsages) {
                    TextRange textRange = ((TextRange)pair.second).shiftRight(((PsiElement)pair.first).getTextOffset());
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                    this.myRangeHighlighters.add(rangeHighlighter);
                }
            }
            for (PsiReference reference : refs) {
                PsiElement element = reference.getElement();
                if (element == null) continue;
                TextRange textRange = element.getTextRange();
                RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                this.myRangeHighlighters.add(rangeHighlighter);
            }
        }).setTitle("String occurrences found").setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(selectedValue -> this.runRenameTemplate(ALL_OCCURRENCES.equals(selectedValue) ? stringUsages : new ArrayList())).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                RenameChooser.this.dropHighlighters();
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    private void dropHighlighters() {
        for (RangeHighlighter highlight : this.myRangeHighlighters) {
            highlight.dispose();
        }
        this.myRangeHighlighters.clear();
    }
}

