/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import org.jetbrains.annotations.NotNull;

public class DefaultNonCodeSearchElementDescriptionProvider
implements ElementDescriptionProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.DefaultNonCodeSearchElementDescriptionProvider");
    public static final DefaultNonCodeSearchElementDescriptionProvider INSTANCE = new DefaultNonCodeSearchElementDescriptionProvider();

    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        PsiMetaOwner psiMetaOwner;
        PsiMetaData metaData;
        if (!(location instanceof NonCodeSearchDescriptionLocation)) {
            return null;
        }
        NonCodeSearchDescriptionLocation ncdLocation = (NonCodeSearchDescriptionLocation)location;
        if (element instanceof PsiDirectory) {
            if (ncdLocation.isNonJava()) {
                String qName = PsiDirectoryFactory.getInstance(element.getProject()).getQualifiedName((PsiDirectory)element, false);
                if (qName.length() > 0) {
                    return qName;
                }
                return null;
            }
            return ((PsiDirectory)element).getName();
        }
        if (element instanceof PsiMetaOwner && (metaData = (psiMetaOwner = (PsiMetaOwner)element).getMetaData()) != null) {
            return metaData.getName();
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return null;
    }
}

