/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JRadioButton;

public class RadioUpDownListener
extends KeyAdapter {
    private final JRadioButton[] myRadioButtons;

    public RadioUpDownListener(JRadioButton ... radioButtons) {
        this.myRadioButtons = radioButtons;
        for (JRadioButton radioButton : radioButtons) {
            radioButton.addKeyListener(this);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int selected = this.getSelected();
        if (selected != -1) {
            if (e.getKeyCode() == 38) {
                this.up(selected, selected);
                e.consume();
            } else if (e.getKeyCode() == 40) {
                this.down(selected, selected);
                e.consume();
            }
        }
    }

    private void down(int selected, int stop2) {
        int newIdx = selected + 1;
        if (newIdx > this.myRadioButtons.length - 1) {
            newIdx = 0;
        }
        if (!RadioUpDownListener.click(this.myRadioButtons[newIdx]) && stop2 != newIdx) {
            this.down(newIdx, selected);
        }
    }

    private void up(int selected, int stop2) {
        int newIdx = selected - 1;
        if (newIdx < 0) {
            newIdx = this.myRadioButtons.length - 1;
        }
        if (!RadioUpDownListener.click(this.myRadioButtons[newIdx]) && stop2 != newIdx) {
            this.up(newIdx, selected);
        }
    }

    private int getSelected() {
        for (int i = 0; i < this.myRadioButtons.length; ++i) {
            if (!this.myRadioButtons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    private static boolean click(JRadioButton button2) {
        if (button2.isEnabled() && button2.isVisible()) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)button2, true));
            button2.doClick();
            return true;
        }
        return false;
    }
}

