/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TextOccurrencesUtil {
    private TextOccurrencesUtil() {
    }

    public static void addTextOccurences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory) {
        PsiSearchHelperImpl.processTextOccurrences(element, stringToSearch, searchScope, (Processor<? super UsageInfo>)((Processor)t -> {
            results.add((UsageInfo)t);
            return true;
        }), factory);
    }

    private static boolean processStringLiteralsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, PsiSearchHelper helper, Processor<? super PsiElement> processor2) {
        TextOccurenceProcessor occurenceProcessor = (element, offsetInElement) -> {
            ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
            ASTNode node = element.getNode();
            if (definition != null && node != null && definition.getStringLiteralElements().contains(node.getElementType())) {
                return processor2.process((Object)element);
            }
            return true;
        };
        return helper.processElementsWithWord(occurenceProcessor, searchScope, identifier, (short)4, true);
    }

    public static boolean processUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull String stringToSearch, boolean ignoreReferences, @NotNull PairProcessor<? super PsiElement, ? super TextRange> processor2) {
        Processor commentOrLiteralProcessor;
        PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)element.getProject());
        SearchScope scope = helper.getUseScope(element);
        return TextOccurrencesUtil.processStringLiteralsContainingIdentifier(stringToSearch, scope = scope.intersectWith((SearchScope)GlobalSearchScope.projectScope((Project)element.getProject())), helper, (Processor<? super PsiElement>)(commentOrLiteralProcessor = literal -> TextOccurrencesUtil.processTextIn(literal, stringToSearch, ignoreReferences, processor2))) && helper.processCommentsContainingIdentifier(stringToSearch, scope, commentOrLiteralProcessor);
    }

    public static void addUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory) {
        Object lock = new Object();
        TextOccurrencesUtil.processUsagesInStringsAndComments(element, stringToSearch, false, (PairProcessor<? super PsiElement, ? super TextRange>)((PairProcessor)(commentOrLiteral, textRange) -> {
            UsageInfo usageInfo = factory.createUsageInfo(commentOrLiteral, textRange.getStartOffset(), textRange.getEndOffset());
            if (usageInfo != null) {
                Object object = lock;
                synchronized (object) {
                    results.add(usageInfo);
                }
            }
            return true;
        }));
    }

    private static boolean processTextIn(PsiElement scope, String stringToSearch, boolean ignoreReferences, PairProcessor<? super PsiElement, ? super TextRange> processor2) {
        String text = scope.getText();
        for (int offset = 0; offset < text.length() && (offset = text.indexOf(stringToSearch, offset)) >= 0; ++offset) {
            char c;
            PsiReference referenceAt = scope.findReferenceAt(offset);
            if (!ignoreReferences && referenceAt != null && (referenceAt.resolve() != null || referenceAt instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)referenceAt).multiResolve(true).length > 0) || offset > 0 && Character.isJavaIdentifierPart(c = text.charAt(offset - 1)) && c != '$' && (offset < 2 || text.charAt(offset - 2) != '\\') || offset + stringToSearch.length() < text.length() && Character.isJavaIdentifierPart(c = text.charAt(offset + stringToSearch.length())) && c != '$') continue;
            TextRange textRange = new TextRange(offset, offset + stringToSearch.length());
            if (!processor2.process((Object)scope, (Object)textRange)) {
                return false;
            }
            offset += stringToSearch.length();
        }
        return true;
    }

    public static boolean isSearchTextOccurencesEnabled(@NotNull PsiElement element) {
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)element.getProject())).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(element, true);
        return FindUsagesUtil.isSearchForTextOccurrencesAvailable(element, false, handler2);
    }

    public static void findNonCodeUsages(PsiElement element, String stringToSearch, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName, Collection<? super UsageInfo> results) {
        if (searchInStringsAndComments || searchInNonJavaFiles) {
            UsageInfoFactory factory = TextOccurrencesUtil.createUsageInfoFactory(element, newQName);
            if (searchInStringsAndComments) {
                TextOccurrencesUtil.addUsagesInStringsAndComments(element, stringToSearch, results, factory);
            }
            if (searchInNonJavaFiles) {
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
                TextOccurrencesUtil.addTextOccurences(element, stringToSearch, projectScope, results, factory);
            }
        }
    }

    private static UsageInfoFactory createUsageInfoFactory(PsiElement element, String newQName) {
        return (usage, startOffset, endOffset) -> {
            int start2 = usage.getTextRange().getStartOffset();
            return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start2 + startOffset), (int)(start2 + endOffset), (PsiElement)element, (String)newQName);
        };
    }
}

