/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PathMappingValidator {
    public static String validatePathMappings(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) {
        boolean found = false;
        SmartList locations = new SmartList();
        for (PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders(data)) {
            found = found || !mappingProvider.getPathMappingSettings(project, data).isEmpty();
            locations.add(mappingProvider.getProviderPresentableName(data));
        }
        if (!found) {
            StringBuilder builder2 = new StringBuilder();
            builder2.append("No path mappings were found.");
            if (!locations.isEmpty()) {
                builder2.append(" Please, configure them at ").append(StringUtil.join((Collection)locations, (String)" or "));
            }
            return builder2.toString();
        }
        return null;
    }
}

