/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkCredentialsBuilder {
    private String myInterpreterPath = null;
    private static final String myHelpersPath = null;
    private RemoteCredentials myRemoteCredentials = null;
    private static final String myHelpersDefaultDirName = ".idea_helpers";

    public RemoteSdkCredentials build() {
        RemoteSdkCredentialsHolder result2 = new RemoteSdkCredentialsHolder(myHelpersDefaultDirName);
        if (this.myRemoteCredentials != null) {
            RemoteSdkCredentialsBuilder.copyCredentials(this.myRemoteCredentials, result2);
        }
        if (this.myInterpreterPath != null) {
            result2.setInterpreterPath(this.myInterpreterPath);
        }
        if (myHelpersPath != null) {
            result2.setHelpersPath(myHelpersPath);
        }
        return result2;
    }

    public static void copyRemoteSdkCredentials(@NotNull RemoteSdkCredentials data, @NotNull RemoteSdkCredentials copyTo2) {
        RemoteSdkCredentialsBuilder.copyCredentials(data, copyTo2);
        copyTo2.setInterpreterPath(data.getInterpreterPath());
        copyTo2.setRunAsRootViaSudo(data.isRunAsRootViaSudo());
        copyTo2.setHelpersPath(data.getHelpersPath());
        copyTo2.setHelpersVersionChecked(data.isHelpersVersionChecked());
        copyTo2.setRemoteRoots(data.getRemoteRoots());
    }

    public static void copyCredentials(@NotNull RemoteCredentials data, @NotNull MutableRemoteCredentials copyTo2) {
        copyTo2.setHost(data.getHost());
        copyTo2.setLiteralPort(data.getLiteralPort());
        copyTo2.setUserName(data.getUserName());
        copyTo2.setPassword(data.getPassword());
        copyTo2.setPrivateKeyFile(data.getPrivateKeyFile());
        copyTo2.setPassphrase(data.getPassphrase());
        copyTo2.setAuthType(data.getAuthType());
        copyTo2.setStorePassword(data.isStorePassword());
        copyTo2.setStorePassphrase(data.isStorePassphrase());
    }

    public RemoteSdkCredentialsBuilder withCredentials(@Nullable RemoteCredentials remoteCredentials) {
        this.myRemoteCredentials = remoteCredentials;
        return this;
    }

    public RemoteSdkCredentialsBuilder withInterpreterPath(String interpreterPath) {
        this.myInterpreterPath = interpreterPath;
        return this;
    }
}

