/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class RemoteServerConnectionTester {
    private final RemoteServer<?> myServer;

    public RemoteServerConnectionTester(@NotNull RemoteServer<?> server) {
        this.myServer = server;
    }

    public void testConnection(final @NotNull Callback callback2) {
        final ServerConnection connection = ServerConnectionManager.getInstance().createTemporaryConnection(this.myServer);
        final AtomicReference<Object> connectedRef = new AtomicReference<Object>(null);
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

            public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                connectedRef.set(true);
                semaphore.up();
                connection.disconnect();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                connectedRef.set(false);
                semaphore.up();
            }
        });
        new Task.Backgroundable(null, "Connecting...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                while (!indicator.isCanceled() && !semaphore.waitFor(500L)) {
                }
                Boolean connected = (Boolean)connectedRef.get();
                if (connected == null) {
                    return;
                }
                callback2.connectionTested(connected, connection.getStatusText());
            }
        }.queue();
    }

    public static interface Callback {
        public void connectionTested(boolean var1, @NotNull String var2);
    }
}

