/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.RemoteServerListConfigurable;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class RemoteServerListConfigurableProvider
extends ConfigurableProvider {
    public boolean canCreateConfigurable() {
        List<ServerType<?>> serverTypes = RemoteServerListConfigurableProvider.getServerTypesInCloudsList();
        return !serverTypes.isEmpty();
    }

    public Configurable createConfigurable() {
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), RemoteServerListConfigurableProvider.getServerTypesInCloudsList(), null);
    }

    @NotNull
    private static List<ServerType<?>> getServerTypesInCloudsList() {
        Set excludedTypes = Configurable.APPLICATION_CONFIGURABLE.extensions().flatMap(RemoteServerListConfigurableProvider::tryGetServerTypes).collect(Collectors.toSet());
        List collection = ServerType.EP_NAME.getExtensionList();
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        for (ServerType t : collection) {
            if (excludedTypes.contains(t)) continue;
            result2.add(t);
        }
        return result2;
    }

    @NotNull
    private static Stream<ServerType<?>> tryGetServerTypes(@NotNull ConfigurableEP<?> ep) {
        UnnamedConfigurable configurable;
        Class type = ep.getConfigurableType();
        if (type != null && RemoteServerListConfigurable.class.isAssignableFrom(type) && (configurable = ep.createConfigurable()) instanceof RemoteServerListConfigurable) {
            return ((RemoteServerListConfigurable)configurable).getDisplayedServerTypes().stream();
        }
        return Stream.empty();
    }
}

