/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.RemoteServerImpl;
import com.intellij.remoteServer.impl.configuration.RemoteServerState;
import com.intellij.remoteServer.impl.configuration.RemoteServersManagerState;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RemoteServers", storages={@Storage(value="remote-servers.xml")})
public class RemoteServersManagerImpl
extends RemoteServersManager
implements PersistentStateComponent<RemoteServersManagerState> {
    public static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private final List<RemoteServer<?>> myServers = new ArrayList();
    private final List<RemoteServerState> myUnknownServers = new ArrayList<RemoteServerState>();
    private final MessageBus myMessageBus;

    public RemoteServersManagerImpl(MessageBus messageBus) {
        this.myMessageBus = messageBus;
    }

    public List<RemoteServer<?>> getServers() {
        return Collections.unmodifiableList(this.myServers);
    }

    public <C extends ServerConfiguration> List<RemoteServer<C>> getServers(@NotNull ServerType<C> type) {
        ArrayList<RemoteServer<C>> servers = new ArrayList<RemoteServer<C>>();
        for (RemoteServer<?> server : this.myServers) {
            if (!server.getType().equals(type)) continue;
            servers.add(server);
        }
        return servers;
    }

    @Nullable
    public <C extends ServerConfiguration> RemoteServer<C> findByName(@NotNull String name, @NotNull ServerType<C> type) {
        for (RemoteServer<?> server : this.myServers) {
            if (!server.getType().equals(type) || !server.getName().equals(name)) continue;
            return server;
        }
        return null;
    }

    @NotNull
    public <C extends ServerConfiguration> RemoteServer<C> createServer(@NotNull ServerType<C> type, @NotNull String name) {
        return new RemoteServerImpl<ServerConfiguration>(name, type, type.createDefaultConfiguration());
    }

    @NotNull
    public <C extends ServerConfiguration> RemoteServer<C> createServer(@NotNull ServerType<C> type) {
        String name = UniqueNameGenerator.generateUniqueName((String)type.getPresentableName(), s -> this.getServers(type).stream().map(RemoteServer::getName).noneMatch(s::equals));
        return this.createServer(type, name);
    }

    public void addServer(RemoteServer<?> server) {
        this.myServers.add(server);
        ((RemoteServerListener)this.myMessageBus.syncPublisher(RemoteServerListener.TOPIC)).serverAdded(server);
    }

    public void removeServer(RemoteServer<?> server) {
        this.myServers.remove(server);
        ((RemoteServerListener)this.myMessageBus.syncPublisher(RemoteServerListener.TOPIC)).serverRemoved(server);
    }

    @Nullable
    public RemoteServersManagerState getState() {
        RemoteServersManagerState state = new RemoteServersManagerState();
        for (RemoteServer<?> server : this.myServers) {
            RemoteServerState serverState = new RemoteServerState();
            serverState.myName = server.getName();
            serverState.myTypeId = server.getType().getId();
            serverState.myConfiguration = XmlSerializer.serialize((Object)server.getConfiguration().getSerializer().getState(), (SerializationFilter)SERIALIZATION_FILTERS);
            state.myServers.add(serverState);
        }
        state.myServers.addAll(this.myUnknownServers);
        return state;
    }

    public void loadState(@NotNull RemoteServersManagerState state) {
        this.myUnknownServers.clear();
        this.myServers.clear();
        LinkedList<CloudConfigurationBase> needsMigration = new LinkedList<CloudConfigurationBase>();
        for (RemoteServerState server : state.myServers) {
            ServerType<?> type = RemoteServersManagerImpl.findServerType(server.myTypeId);
            if (type == null) {
                this.myUnknownServers.add(server);
                continue;
            }
            RemoteServerImpl<?> nextServer = RemoteServersManagerImpl.createConfiguration(type, server);
            this.myServers.add(nextServer);
            ServerConfiguration nextConfig = nextServer.getConfiguration();
            if (!(nextConfig instanceof CloudConfigurationBase) || !((CloudConfigurationBase)nextConfig).shouldMigrateToPasswordSafe()) continue;
            needsMigration.add((CloudConfigurationBase)nextConfig);
        }
        if (!needsMigration.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                for (CloudConfigurationBase nextConfig : needsMigration) {
                    nextConfig.migrateToPasswordSafe();
                }
            });
        }
    }

    @NotNull
    private static <C extends ServerConfiguration> RemoteServerImpl<C> createConfiguration(ServerType<C> type, RemoteServerState server) {
        ServerConfiguration configuration2 = type.createDefaultConfiguration();
        PersistentStateComponent serializer = configuration2.getSerializer();
        ComponentSerializationUtil.loadComponentState((PersistentStateComponent)serializer, (Element)server.myConfiguration);
        return new RemoteServerImpl<ServerConfiguration>(server.myName, type, configuration2);
    }

    @Nullable
    private static ServerType<?> findServerType(@NotNull String typeId) {
        for (ServerType serverType : (ServerType[])ServerType.EP_NAME.getExtensions()) {
            if (!serverType.getId().equals(typeId)) continue;
            return serverType;
        }
        return null;
    }
}

