/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeployToServerConfigurationType
extends ConfigurationTypeBase {
    private final ServerType<?> myServerType;
    private final MultiSourcesConfigurationFactory myMultiSourcesFactory;
    private final Map<SingletonDeploymentSourceType, SingletonTypeConfigurationFactory> myPerTypeFactories = new HashMap<SingletonDeploymentSourceType, SingletonTypeConfigurationFactory>();

    public DeployToServerConfigurationType(@NotNull ServerType<?> serverType) {
        super(serverType.getId() + "-deploy", serverType.getDeploymentConfigurationTypePresentableName(), "Deploy to " + serverType.getPresentableName() + " run configuration", serverType.getIcon());
        this.myServerType = serverType;
        if (this.myServerType.mayHaveProjectSpecificDeploymentSources()) {
            this.myMultiSourcesFactory = new MultiSourcesConfigurationFactory();
            this.addFactory(this.myMultiSourcesFactory);
        } else {
            this.myMultiSourcesFactory = null;
        }
        for (SingletonDeploymentSourceType next : serverType.getSingletonDeploymentSourceTypes()) {
            SingletonTypeConfigurationFactory nextFactory = new SingletonTypeConfigurationFactory(next);
            this.addFactory(nextFactory);
            this.myPerTypeFactories.put(next, nextFactory);
        }
    }

    @NotNull
    public ConfigurationFactory getFactoryForType(@Nullable DeploymentSourceType<?> sourceType) {
        MultiSourcesConfigurationFactory result2 = null;
        if (sourceType instanceof SingletonDeploymentSourceType && this.myServerType.getSingletonDeploymentSourceTypes().contains(sourceType)) {
            result2 = this.myPerTypeFactories.get(sourceType);
        }
        if (result2 == null) {
            result2 = this.myMultiSourcesFactory;
        }
        assert (result2 != null) : "server type: " + this.myServerType + ", requested source type: " + sourceType;
        return result2;
    }

    @Deprecated
    public ConfigurationFactoryEx getFactory() {
        return (ConfigurationFactoryEx)this.getFactoryForType(null);
    }

    @NotNull
    public ServerType<?> getServerType() {
        return this.myServerType;
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug." + this.myServerType.getId() + "-deploy";
    }

    public final class SingletonTypeConfigurationFactory
    extends DeployToServerConfigurationFactory {
        private final SingletonDeploymentSourceType mySourceType;

        public SingletonTypeConfigurationFactory(SingletonDeploymentSourceType sourceType) {
            this.mySourceType = sourceType;
        }

        @NotNull
        public String getId() {
            return this.mySourceType.getId();
        }

        @NotNull
        @Nls
        public String getName() {
            return this.mySourceType.getPresentableName();
        }

        @Override
        @NotNull
        public DeployToServerRunConfiguration createTemplateConfiguration(@NotNull Project project) {
            DeployToServerRunConfiguration result2 = super.createTemplateConfiguration(project);
            result2.lockDeploymentSource(this.mySourceType);
            return result2;
        }
    }

    public final class MultiSourcesConfigurationFactory
    extends DeployToServerConfigurationFactory {
        @NotNull
        public String getId() {
            return DeployToServerConfigurationType.this.getDisplayName();
        }
    }

    public class DeployToServerConfigurationFactory
    extends ConfigurationFactoryEx<DeployToServerRunConfiguration<?, ?>> {
        public DeployToServerConfigurationFactory() {
            super((ConfigurationType)DeployToServerConfigurationType.this);
        }

        public boolean isApplicable(@NotNull Project project) {
            return DeployToServerConfigurationType.this.myServerType.canAutoDetectConfiguration() || !RemoteServersManager.getInstance().getServers(DeployToServerConfigurationType.this.myServerType).isEmpty();
        }

        @NotNull
        public DeployToServerRunConfiguration createTemplateConfiguration(@NotNull Project project) {
            DeploymentConfigurator deploymentConfigurator = DeployToServerConfigurationType.this.myServerType.createDeploymentConfigurator(project);
            return new DeployToServerRunConfiguration(project, this, "", DeployToServerConfigurationType.this.myServerType, deploymentConfigurator);
        }
    }
}

