/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployToServerState<S extends ServerConfiguration, D extends DeploymentConfiguration>
implements RunProfileState {
    @NotNull
    private final RemoteServer<S> myServer;
    @NotNull
    private final DeploymentSource mySource;
    @NotNull
    private final D myConfiguration;
    @NotNull
    private final ExecutionEnvironment myEnvironment;

    public DeployToServerState(@NotNull RemoteServer<S> server, @NotNull DeploymentSource deploymentSource, @NotNull D deploymentConfiguration, @NotNull ExecutionEnvironment environment) {
        this.myServer = server;
        this.mySource = deploymentSource;
        this.myConfiguration = deploymentConfiguration;
        this.myEnvironment = environment;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        ServerConnection connection = ServerConnectionManager.getInstance().getOrCreateConnection(this.myServer);
        Project project = this.myEnvironment.getProject();
        RemoteServersView.getInstance(project).showServerConnection(connection);
        DebugConnector debugConnector = DefaultDebugExecutor.getDebugExecutorInstance().equals(executor) ? this.myServer.getType().createDebugConnector() : null;
        connection.deploy(new DeploymentTaskImpl<D>(this.mySource, this.myConfiguration, project, debugConnector, this.myEnvironment), s -> RemoteServersView.getInstance(project).showDeployment(connection, (String)s));
        return null;
    }
}

