/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionEventDispatcher;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.ServerTaskExecutorImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConnectionManagerImpl
extends ServerConnectionManager {
    private final Map<RemoteServer<?>, ServerConnection> myConnections = new HashMap();
    private final ServerConnectionEventDispatcher myEventDispatcher = new ServerConnectionEventDispatcher();

    @NotNull
    public <C extends ServerConfiguration> ServerConnection getOrCreateConnection(@NotNull RemoteServer<C> server) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ServerConnection connection = this.myConnections.get(server);
        if (connection == null) {
            connection = this.doCreateConnection(server, this);
            this.myConnections.put(server, connection);
            this.myEventDispatcher.fireConnectionCreated(connection);
        }
        return connection;
    }

    @NotNull
    public <C extends ServerConfiguration> ServerConnection createTemporaryConnection(@NotNull RemoteServer<C> server) {
        return this.doCreateConnection(server, null);
    }

    private <C extends ServerConfiguration> ServerConnection doCreateConnection(@NotNull RemoteServer<C> server, ServerConnectionManagerImpl manager) {
        ServerTaskExecutorImpl executor = new ServerTaskExecutorImpl();
        return new ServerConnectionImpl(server, server.getType().createConnector(server, (ServerTaskExecutor)executor), manager, this.getEventDispatcher());
    }

    @Nullable
    public <C extends ServerConfiguration> ServerConnection getConnection(@NotNull RemoteServer<C> server) {
        return this.myConnections.get(server);
    }

    public void removeConnection(RemoteServer<?> server) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myConnections.remove(server);
    }

    public ServerConnectionEventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    @NotNull
    public Collection<ServerConnection> getConnections() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return Collections.unmodifiableCollection(this.myConnections.values());
    }
}

