/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.TreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteServersViewContribution
extends RemoteServersViewContributor {
    @NonNls
    private static final String HELP_ID = "Application_Servers_tool_window";

    public abstract List<RemoteServer<?>> getRemoteServers();

    @Override
    public boolean canContribute(@NotNull Project project) {
        return !this.getRemoteServers().isEmpty();
    }

    public ServersTreeStructure createTreeStructure(@NotNull Project project, @NotNull ServersTreeNodeSelector nodeSelector) {
        return new ServersTreeStructure(project, this, nodeSelector);
    }

    public TreeNodeSelector createLogNodeSelector(final ServerConnection<?> connection, final String deploymentName, final String logName) {
        return new TreeNodeSelector<ServersTreeStructure.DeploymentLogNode>(){

            @Override
            public boolean visit(@NotNull ServersTreeStructure.DeploymentLogNode node) {
                AbstractTreeNode parent = node.getParent();
                return parent instanceof ServersTreeStructure.DeploymentNodeImpl && ServersToolWindowContent.isDeploymentNodeMatch((ServersTreeStructure.DeploymentNodeImpl)parent, connection, deploymentName) && ((LoggingHandlerBase)node.getValue()).getPresentableName().equals(logName);
            }

            @Override
            public Class<ServersTreeStructure.DeploymentLogNode> getNodeClass() {
                return ServersTreeStructure.DeploymentLogNode.class;
            }
        };
    }

    public static String getRemoteServerToolWindowId(RemoteServer<?> server) {
        String serverToolWindowId = server.getConfiguration().getCustomToolWindowId();
        return serverToolWindowId != null ? serverToolWindowId : server.getType().getCustomToolWindowId();
    }

    protected static List<RemoteServer<?>> getRemoteServersByToolWindowId(@Nullable String toolWindowId) {
        return ContainerUtil.filter((Collection)RemoteServersManager.getInstance().getServers(), server -> RemoteServersViewContribution.getRemoteServerToolWindowId(server) == toolWindowId);
    }

    protected String getContextHelpId() {
        return HELP_ID;
    }
}

