/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.execution.dashboard.TreeContent;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowMessagePanel;
import com.intellij.remoteServer.impl.runtime.ui.TreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.impl.runtime.ui.tree.TreeBuilderBase;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionListener;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ServersToolWindowContent
extends JPanel
implements Disposable,
ServersTreeNodeSelector,
TreeContent {
    public static final DataKey<ServersToolWindowContent> KEY = DataKey.create((String)"serversToolWindowContent");
    @NonNls
    private static final String PLACE_TOOLBAR = "ServersToolWindowContent#Toolbar";
    @NonNls
    private static final String PLACE_TOOLBAR_TOP = "ServersToolWindowContent#Toolbar.Top";
    private static final String MESSAGE_CARD = "message";
    private static final String EMPTY_SELECTION_MESSAGE = "Select a server or deployment in the tree to view details";
    private static final int POLL_DEPLOYMENTS_DELAY = 2000;
    private final Tree myTree;
    private final CardLayout myPropertiesPanelLayout;
    private final JPanel myPropertiesPanel;
    private final MessagePanel myMessagePanel;
    private final Map<String, JComponent> myLogComponents = new HashMap<String, JComponent>();
    private final DefaultTreeModel myTreeModel;
    private TreeBuilderBase myBuilder;
    private AbstractTreeNode<?> myLastSelection;
    private final Set<Object> myCollapsedTreeNodeValues = new HashSet<Object>();
    private final Project myProject;
    private final RemoteServersViewContribution myContribution;
    private final Splitter mySplitter;

    @Deprecated
    public ServersToolWindowContent(@NotNull Project project, @NotNull RemoteServersViewContribution contribution) {
        this(project, contribution, ActionGroups.SHARED_ACTION_GROUPS);
    }

    public ServersToolWindowContent(@NotNull Project project, @NotNull RemoteServersViewContribution contribution, @NotNull ActionGroups actionGroups) {
        super(new BorderLayout());
        this.myProject = project;
        this.myContribution = contribution;
        this.myTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.setLineStyleAngled();
        this.getMainPanel().add((Component)this.createTopToolbar(actionGroups.getSecondaryToolbarID()), "North");
        this.getMainPanel().add((Component)this.createMainToolbar(actionGroups.getMainToolbarID()), "West");
        this.mySplitter = new Splitter(false, 0.3f);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)1));
        this.myPropertiesPanelLayout = new CardLayout();
        this.myPropertiesPanel = new JPanel(this.myPropertiesPanelLayout);
        this.myMessagePanel = new ServersToolWindowMessagePanel();
        this.myMessagePanel.setEmptyText(EMPTY_SELECTION_MESSAGE);
        this.myPropertiesPanel.add(MESSAGE_CARD, this.myMessagePanel.getComponent());
        this.mySplitter.setSecondComponent((JComponent)this.myPropertiesPanel);
        this.getMainPanel().add((Component)this.mySplitter, "Center");
        this.setupBuilder(project);
        contribution.setupTree(this.myProject, this.myTree, this.myBuilder);
        this.myTree.addTreeSelectionListener(e -> this.onSelectionChanged());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                AnAction connectAction = ActionManager.getInstance().getAction("RemoteServers.ConnectServer");
                AnActionEvent actionEvent = AnActionEvent.createFromInputEvent((AnAction)connectAction, (InputEvent)event, (String)"unknown");
                connectAction.actionPerformed(actionEvent);
                return true;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object value = this.getNodeValue(event);
                if (value != null) {
                    ServersToolWindowContent.this.myCollapsedTreeNodeValues.remove(value);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                Object value = this.getNodeValue(event);
                if (value != null) {
                    ServersToolWindowContent.this.myCollapsedTreeNodeValues.add(value);
                }
            }

            private Object getNodeValue(TreeExpansionEvent event) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)event.getPath().getLastPathComponent(), DefaultMutableTreeNode.class);
                if (treeNode == null) {
                    return null;
                }
                AbstractTreeNode nodeDescriptor = (AbstractTreeNode)ObjectUtils.tryCast((Object)treeNode.getUserObject(), AbstractTreeNode.class);
                if (nodeDescriptor == null) {
                    return null;
                }
                return nodeDescriptor.getValue();
            }
        });
        DefaultActionGroup popupActionGroup = new DefaultActionGroup();
        popupActionGroup.add(ActionManager.getInstance().getAction(actionGroups.getMainToolbarID()));
        popupActionGroup.add(ActionManager.getInstance().getAction(actionGroups.getPopupID()));
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)popupActionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
        new TreeSpeedSearch(this.myTree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
        this.restoreSplitterProportion();
        this.myPropertiesPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ServersToolWindowContent.this.saveSplitterProportion();
            }
        });
    }

    private void onSelectionChanged() {
        Set nodes = this.myBuilder.getSelectedElements(AbstractTreeNode.class);
        if (nodes.size() != 1) {
            this.showMessageLabel(EMPTY_SELECTION_MESSAGE);
            this.myLastSelection = null;
            return;
        }
        AbstractTreeNode node = (AbstractTreeNode)nodes.iterator().next();
        if (Comparing.equal((Object)node, this.myLastSelection)) {
            return;
        }
        this.myLastSelection = node;
        if (node instanceof ServersTreeStructure.LogProvidingNode) {
            ServersTreeStructure.LogProvidingNode logNode = (ServersTreeStructure.LogProvidingNode)node;
            JComponent logComponent = logNode.getComponent();
            if (logComponent != null) {
                String cardName = logNode.getLogId();
                JComponent oldComponent = this.myLogComponents.get(cardName);
                if (!logComponent.equals(oldComponent)) {
                    this.myLogComponents.put(cardName, logComponent);
                    if (oldComponent != null) {
                        this.myPropertiesPanel.remove(oldComponent);
                    }
                    this.myPropertiesPanel.add(cardName, logComponent);
                }
                this.myPropertiesPanelLayout.show(this.myPropertiesPanel, cardName);
            } else {
                this.showMessageLabel("");
            }
        } else if (node instanceof ServersTreeStructure.RemoteServerNode) {
            this.updateServerDetails((ServersTreeStructure.RemoteServerNode)node);
        } else {
            this.showMessageLabel("");
        }
    }

    private void updateServerDetails(ServersTreeStructure.RemoteServerNode node) {
        ServerConnection connection = ServerConnectionManager.getInstance().getConnection(node.getServer());
        if (connection == null) {
            this.showMessageLabel("Double-click on the server node to connect");
        } else {
            this.showMessageLabel(connection.getStatusText());
        }
    }

    private void showMessageLabel(@NotNull String text) {
        if (text.contains("<br/>") && !text.startsWith("<html>")) {
            String html = "<html><center>" + text + "</center></html>";
            this.myMessagePanel.setEmptyText(html);
        } else {
            this.myMessagePanel.setEmptyText(text);
        }
        this.myPropertiesPanelLayout.show(this.myPropertiesPanel, MESSAGE_CARD);
    }

    private void setupBuilder(@NotNull Project project) {
        ServersTreeStructure structure = this.myContribution.createTreeStructure(project, this);
        this.myBuilder = new TreeBuilderBase((JTree)this.myTree, structure, this.myTreeModel){

            protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                return (nodeDescriptor instanceof ServersTreeStructure.RemoteServerNode || nodeDescriptor instanceof ServersTreeStructure.DeploymentNodeImpl) && !ServersToolWindowContent.this.myCollapsedTreeNodeValues.contains(((AbstractTreeNode)nodeDescriptor).getValue());
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        project.getMessageBus().connect().subscribe(ServerConnectionListener.TOPIC, (Object)new ServerConnectionListener(){

            public void onConnectionCreated(@NotNull ServerConnection<?> connection) {
                ServersToolWindowContent.this.getBuilder().queueUpdate();
            }

            public void onConnectionStatusChanged(@NotNull ServerConnection<?> connection) {
                ServersToolWindowContent.this.getBuilder().queueUpdate();
                ServersToolWindowContent.this.updateSelectedServerDetails();
                if (connection.getStatus() == ConnectionStatus.CONNECTED) {
                    ServersToolWindowContent.pollDeployments(connection);
                }
            }

            public void onDeploymentsChanged(@NotNull ServerConnection<?> connection) {
                ServersToolWindowContent.this.getBuilder().queueUpdate();
                ServersToolWindowContent.this.updateSelectedServerDetails();
            }
        });
        project.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                ServersToolWindowContent.this.getBuilder().queueUpdate();
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                ServersToolWindowContent.this.getBuilder().queueUpdate();
            }
        });
    }

    private void updateSelectedServerDetails() {
        if (this.myLastSelection instanceof ServersTreeStructure.RemoteServerNode) {
            this.updateServerDetails((ServersTreeStructure.RemoteServerNode)this.myLastSelection);
        }
    }

    private static void pollDeployments(ServerConnection connection) {
        connection.computeDeployments(() -> new Alarm().addRequest(() -> {
            if (connection == ServerConnectionManager.getInstance().getConnection(connection.getServer())) {
                ServersToolWindowContent.pollDeployments(connection);
            }
        }, 2000, ModalityState.any()));
    }

    private JComponent createTopToolbar(@NotNull String actionGroupID) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction(actionGroupID));
        ActionToolbar topToolbar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR_TOP, (ActionGroup)group, true);
        topToolbar.setTargetComponent((JComponent)this.myTree);
        return topToolbar.getComponent();
    }

    private JComponent createMainToolbar(@NotNull String actionGroupID) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction(actionGroupID));
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)group, false);
        this.myTree.putClientProperty((Object)"DataProvider", dataId -> {
            if (KEY.getName().equals(dataId)) {
                return this;
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return this.myBuilder.getSelectedElements().toArray();
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return this.myContribution.getContextHelpId();
            }
            return this.myContribution.getData(dataId, this);
        });
        actionToolBar.setTargetComponent((JComponent)this.myTree);
        return actionToolBar.getComponent();
    }

    private void saveSplitterProportion() {
        SplitterProportionsDataImpl data = new SplitterProportionsDataImpl();
        data.saveSplitterProportions((Component)this.mySplitter);
        data.externalizeToDimensionService(this.getDimensionServiceKey());
    }

    private void restoreSplitterProportion() {
        SplitterProportionsDataImpl data = new SplitterProportionsDataImpl();
        data.externalizeFromDimensionService(this.getDimensionServiceKey());
        data.restoreSplitterProportions((Component)this.mySplitter);
    }

    private String getDimensionServiceKey() {
        return this.getClass().getName() + ":" + this.myContribution.getClass().getName();
    }

    public JPanel getMainPanel() {
        return this;
    }

    public void dispose() {
    }

    @NotNull
    public TreeBuilderBase getBuilder() {
        return this.myBuilder;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void select(@NotNull ServerConnection<?> connection) {
        this.myBuilder.select(ServersTreeStructure.RemoteServerNode.class, node -> ServersToolWindowContent.isServerNodeMatch(node, connection), null, false);
    }

    @Override
    public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName) {
        this.myBuilder.getUi().queueUpdate(connection).doWhenDone(() -> this.myBuilder.select(ServersTreeStructure.DeploymentNodeImpl.class, node -> ServersToolWindowContent.isDeploymentNodeMatch(node, connection, deploymentName), null, false));
    }

    @Override
    public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName, @NotNull String logName) {
        this.myBuilder.getUi().queueUpdate(connection).doWhenDone(() -> {
            TreeNodeSelector nodeSelector = this.myContribution.createLogNodeSelector(connection, deploymentName, logName);
            this.myBuilder.select(nodeSelector.getNodeClass(), nodeSelector, null, false);
        });
    }

    private static boolean isServerNodeMatch(@NotNull ServersTreeStructure.RemoteServerNode node, @NotNull ServerConnection<?> connection) {
        return node.getServer().equals((Object)connection.getServer());
    }

    public static boolean isDeploymentNodeMatch(@NotNull ServersTreeStructure.DeploymentNodeImpl node, @NotNull ServerConnection<?> connection, @NotNull String deploymentName) {
        ServersTreeStructure.RemoteServerNode serverNode = node.getServerNode();
        return ServersToolWindowContent.isServerNodeMatch(serverNode, connection) && node.getDeployment().getName().equals(deploymentName);
    }

    public static MessagePanel createMessagePanel() {
        return new ServersToolWindowMessagePanel();
    }

    public static interface MessagePanel {
        public void setEmptyText(@NotNull String var1);

        @NotNull
        public JComponent getComponent();
    }

    public static class ActionGroups {
        @NotNull
        private final String myMainToolbarID;
        @NotNull
        private final String mySecondaryToolbarID;
        @NotNull
        private final String myPopupID;
        public static final ActionGroups SHARED_ACTION_GROUPS = new ActionGroups("RemoteServersViewToolbar", "RemoteServersViewToolbar.Top", "RemoteServersViewPopup");

        public ActionGroups(@NotNull String mainToolbarID, @NotNull String secondaryToolbarID, @NotNull String popupID) {
            this.myMainToolbarID = mainToolbarID;
            this.mySecondaryToolbarID = secondaryToolbarID;
            this.myPopupID = popupID;
        }

        @NotNull
        public String getMainToolbarID() {
            return this.myMainToolbarID;
        }

        @NotNull
        public String getPopupID() {
            return this.myPopupID;
        }

        @NotNull
        public String getSecondaryToolbarID() {
            return this.mySecondaryToolbarID;
        }
    }
}

