/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ServersToolWindowFactory
implements ToolWindowFactory,
Condition<Project>,
DumbAware {
    private final RemoteServersViewContribution myContribution;

    public ServersToolWindowFactory(RemoteServersViewContribution contribution) {
        this.myContribution = contribution;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ServersToolWindowContent serversContent = this.doCreateToolWindowContent(project);
        Content content = contentFactory.createContent((JComponent)serversContent.getMainPanel(), null, false);
        content.setHelpId(this.getContribution().getContextHelpId());
        Disposer.register((Disposable)content, (Disposable)serversContent);
        toolWindow.getContentManager().addContent(content);
    }

    @NotNull
    protected ServersToolWindowContent doCreateToolWindowContent(@NotNull Project project) {
        return new ServersToolWindowContent(project, this.myContribution, ServersToolWindowContent.ActionGroups.SHARED_ACTION_GROUPS);
    }

    public boolean value(Project project) {
        return this.myContribution.canContribute(project);
    }

    public RemoteServersViewContribution getContribution() {
        return this.myContribution;
    }
}

