/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowFactory;
import com.intellij.util.ui.update.UiNotifyConnector;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ServersToolWindowManager {
    @NotNull
    private final Project myProject;
    private final String myWindowId;
    private final Icon myIcon;

    public ServersToolWindowManager(@NotNull Project project, String windowId, Icon icon) {
        this.myProject = project;
        this.myWindowId = windowId;
        this.myIcon = icon;
        StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> this.setupListeners());
    }

    public void setupListeners() {
        this.getFactory().getContribution().setupAvailabilityListener(this.myProject, () -> this.updateWindowAvailable(true));
        this.myProject.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                ServersToolWindowManager.this.updateWindowAvailable(true);
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                ServersToolWindowManager.this.updateWindowAvailable(false);
            }
        });
    }

    private void updateWindowAvailable(boolean showIfAvailable) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(() -> {
            boolean available = this.getFactory().getContribution().canContribute(this.myProject);
            ToolWindow toolWindow = toolWindowManager.getToolWindow(this.myWindowId);
            if (toolWindow == null) {
                if (available) {
                    this.createToolWindow(this.myProject, toolWindowManager, false).show(null);
                }
                return;
            }
            this.doUpdateWindowAvailable(toolWindow, showIfAvailable, available);
        });
    }

    protected void doUpdateWindowAvailable(@NotNull ToolWindow toolWindow, boolean showIfAvailable, boolean available) {
        boolean doShow;
        boolean bl = doShow = !toolWindow.isAvailable() && available;
        if (toolWindow.isAvailable() && !available) {
            toolWindow.hide(null);
        }
        toolWindow.setAvailable(available, null);
        if (showIfAvailable && doShow) {
            toolWindow.show(null);
        }
    }

    @Deprecated
    protected ToolWindow createToolWindow(Project project, ToolWindowManager toolWindowManager) {
        return this.createToolWindow(project, toolWindowManager, false);
    }

    protected ToolWindow createToolWindow(Project project, ToolWindowManager toolWindowManager, boolean deferContentCreation) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.myWindowId, false, ToolWindowAnchor.BOTTOM);
        toolWindow.setIcon(this.myIcon);
        Runnable createContent = () -> this.getFactory().createToolWindowContent(project, toolWindow);
        if (deferContentCreation) {
            UiNotifyConnector.doWhenFirstShown((JComponent)toolWindow.getContentManager().getComponent(), (Runnable)createContent);
        } else {
            createContent.run();
        }
        return toolWindow;
    }

    @NotNull
    protected abstract ServersToolWindowFactory getFactory();

    @NotNull
    protected final Project getProject() {
        return this.myProject;
    }
}

