/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui.tree;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.SingleRemoteServerConfigurable;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import icons.RemoteServersIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServersTreeStructure
extends AbstractTreeStructureBase {
    private final ServersTreeRootNode myRootElement;
    private final Project myProject;
    private final RemoteServersViewContribution myContribution;
    private final ServersTreeNodeSelector myNodeSelector;

    public ServersTreeStructure(@NotNull Project project, @NotNull RemoteServersViewContribution contribution, @NotNull ServersTreeNodeSelector nodeSelector) {
        super(project);
        this.myProject = project;
        this.myContribution = contribution;
        this.myNodeSelector = nodeSelector;
        this.myRootElement = new ServersTreeRootNode();
    }

    public static Icon getServerNodeIcon(@NotNull Icon itemIcon, @Nullable Icon statusIcon) {
        if (statusIcon == null) {
            return itemIcon;
        }
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(itemIcon, 0);
        icon.setIcon(statusIcon, 1, itemIcon.getIconWidth() - statusIcon.getIconWidth(), itemIcon.getIconHeight() - statusIcon.getIconHeight());
        return icon;
    }

    @Override
    public List<TreeStructureProvider> getProviders() {
        return Collections.emptyList();
    }

    @NotNull
    protected Project doGetProject() {
        return this.myProject;
    }

    @NotNull
    public Object getRootElement() {
        return this.myRootElement;
    }

    protected ServersTreeNodeSelector getNodeSelector() {
        return this.myNodeSelector;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    protected AbstractTreeNode createDeploymentNode(ServerConnection<?> connection, RemoteServerNode serverNode, Deployment deployment) {
        return new DeploymentNodeImpl(this.myProject, connection, serverNode, deployment, this::createDeploymentNode);
    }

    @FunctionalInterface
    public static interface DeploymentNodeProducer {
        public AbstractTreeNode createDeploymentNode(ServerConnection<?> var1, RemoteServerNode var2, Deployment var3);
    }

    public static class DeploymentLogNode
    extends AbstractTreeNode<LoggingHandlerBase>
    implements ServersTreeNode,
    LogProvidingNode {
        @NotNull
        private final DeploymentNodeImpl myDeploymentNode;

        public DeploymentLogNode(Project project, @NotNull LoggingHandlerBase value, @NotNull DeploymentNodeImpl deploymentNode) {
            super(project, (Object)value);
            this.myDeploymentNode = deploymentNode;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            return Collections.emptyList();
        }

        protected void update(@NotNull PresentationData presentation) {
            presentation.setIcon(AllIcons.Debugger.Console);
            presentation.setPresentableText(this.getLogName());
        }

        private String getLogName() {
            return ((LoggingHandlerBase)this.getValue()).getPresentableName();
        }

        @Override
        @Nullable
        public JComponent getComponent() {
            return ((LoggingHandlerBase)this.getValue()).getComponent();
        }

        @Override
        @NotNull
        public String getLogId() {
            return this.myDeploymentNode.getId() + ";log:" + this.getLogName();
        }
    }

    public static class DeploymentNodeImpl
    extends AbstractTreeNode<Deployment>
    implements LogProvidingNode,
    DeploymentNode {
        private final ServerConnection<?> myConnection;
        private final RemoteServerNode myServerNode;
        private final DeploymentNodeProducer myNodeProducer;

        protected DeploymentNodeImpl(Project project, @NotNull ServerConnection<?> connection, @NotNull RemoteServerNode serverNode, @NotNull Deployment value, @NotNull DeploymentNodeProducer nodeProducer) {
            super(project, (Object)value);
            this.myConnection = connection;
            this.myServerNode = serverNode;
            this.myNodeProducer = nodeProducer;
        }

        @NotNull
        public Deployment getDeployment() {
            return (Deployment)this.getValue();
        }

        @Override
        @NotNull
        public RemoteServerNode getServerNode() {
            return this.myServerNode;
        }

        @Override
        public boolean isDeployActionVisible() {
            DeploymentTask deploymentTask = ((Deployment)this.getValue()).getDeploymentTask();
            return deploymentTask instanceof DeploymentTaskImpl && deploymentTask.getExecutionEnvironment().getRunnerAndConfigurationSettings() != null;
        }

        @Override
        public boolean isDeployActionEnabled() {
            return true;
        }

        @Override
        public void deploy() {
            this.doDeploy(DefaultRunExecutor.getRunExecutorInstance());
        }

        public void doDeploy(Executor executor) {
            ExecutionEnvironment environment;
            RunnerAndConfigurationSettings settings;
            DeploymentTask deploymentTask = this.getDeployment().getDeploymentTask();
            if (deploymentTask != null && (settings = (environment = deploymentTask.getExecutionEnvironment()).getRunnerAndConfigurationSettings()) != null) {
                ProgramRunnerUtil.executeConfiguration(settings, executor);
            }
        }

        @Override
        public boolean isDebugActionVisible() {
            return this.myServerNode.getServer().getType().createDebugConnector() != null;
        }

        @Override
        public void deployWithDebug() {
            this.doDeploy(DefaultDebugExecutor.getDebugExecutorInstance());
        }

        @Override
        public boolean isUndeployActionEnabled() {
            DeploymentRuntime runtime = this.getDeployment().getRuntime();
            return runtime != null && runtime.isUndeploySupported();
        }

        @Override
        public void undeploy() {
            DeploymentRuntime runtime = this.getDeployment().getRuntime();
            if (runtime != null) {
                this.getConnection().undeploy(this.getDeployment(), runtime);
            }
        }

        public boolean isEditConfigurationActionVisible() {
            return this.getDeployment().getDeploymentTask() != null;
        }

        public void editConfiguration() {
            RunnerAndConfigurationSettings settings;
            DeploymentTask task2 = this.getDeployment().getDeploymentTask();
            if (task2 != null && (settings = task2.getExecutionEnvironment().getRunnerAndConfigurationSettings()) != null) {
                RunDialog.editConfiguration(this.myProject, settings, "Edit Deployment Configuration");
            }
        }

        @Override
        public boolean isDeployed() {
            return this.getDeployment().getStatus() == DeploymentStatus.DEPLOYED;
        }

        @Override
        public String getDeploymentName() {
            return this.getDeployment().getName();
        }

        public ServerConnection<?> getConnection() {
            return this.myConnection;
        }

        @Override
        @Nullable
        public JComponent getComponent() {
            DeploymentLogManagerImpl logManager = this.getLogManager();
            return logManager != null && logManager.isMainHandlerVisible() ? logManager.getMainLoggingHandler().getConsole().getComponent() : null;
        }

        @Nullable
        protected DeploymentLogManagerImpl getLogManager() {
            return (DeploymentLogManagerImpl)this.myConnection.getLogManager(this.myProject, this.getDeployment());
        }

        public String getId() {
            return this.myServerNode.getName() + ";deployment" + this.getDeployment().getName();
        }

        @Override
        @NotNull
        public String getLogId() {
            return this.getId() + ";main-log";
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
            this.collectDeploymentChildren(result2);
            this.collectLogChildren(result2);
            return result2;
        }

        protected void collectDeploymentChildren(List<AbstractTreeNode> children2) {
            ServerConnection<?> connection = this.getConnection();
            if (connection == null) {
                return;
            }
            for (Deployment deployment : connection.getDeployments()) {
                DeploymentRuntime parent = deployment.getParentRuntime();
                if (parent == null || parent != this.getDeployment().getRuntime()) continue;
                children2.add(this.myNodeProducer.createDeploymentNode(connection, this.myServerNode, deployment));
            }
        }

        protected void collectLogChildren(List<AbstractTreeNode> children2) {
            ServerConnection<?> connection = this.getConnection();
            if (connection == null) {
                return;
            }
            DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)connection.getLogManager(this.myProject, this.getDeployment());
            if (logManager != null) {
                for (LoggingHandlerBase loggingComponent : logManager.getAdditionalLoggingHandlers()) {
                    children2.add(new DeploymentLogNode(this.myProject, loggingComponent, this));
                }
            }
        }

        protected void update(@NotNull PresentationData presentation) {
            Deployment deployment = this.getDeployment();
            presentation.setIcon(deployment.getStatus().getIcon());
            presentation.setPresentableText(deployment.getPresentableName());
            presentation.setTooltip(deployment.getStatusText());
        }
    }

    public static class RemoteServerNode
    extends AbstractTreeNode<RemoteServer<?>>
    implements ServerNode {
        private final DeploymentNodeProducer myNodeProducer;

        public RemoteServerNode(Project project, @NotNull RemoteServer<?> server, @NotNull DeploymentNodeProducer nodeProducer) {
            super(project, server);
            this.myNodeProducer = nodeProducer;
        }

        @NotNull
        public RemoteServer<?> getServer() {
            return (RemoteServer)this.getValue();
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ServerConnection<?> connection = this.getConnection();
            if (connection == null) {
                return Collections.emptyList();
            }
            ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
            for (Deployment deployment : connection.getDeployments()) {
                if (deployment.getParentRuntime() != null) continue;
                children2.add(this.myNodeProducer.createDeploymentNode(connection, this, deployment));
            }
            return children2;
        }

        protected void update(@NotNull PresentationData presentation) {
            RemoteServer<?> server = this.getServer();
            ServerConnection<?> connection = this.getConnection();
            presentation.setPresentableText(server.getName());
            presentation.setIcon(ServersTreeStructure.getServerNodeIcon(server.getType().getIcon(), connection != null ? this.getStatusIcon(connection.getStatus()) : null));
            presentation.setTooltip(connection != null ? connection.getStatusText() : null);
        }

        @Nullable
        private ServerConnection<?> getConnection() {
            return ServerConnectionManager.getInstance().getConnection(this.getServer());
        }

        public boolean isConnected() {
            ServerConnection<?> connection = this.getConnection();
            return connection != null && connection.getStatus() == ConnectionStatus.CONNECTED;
        }

        public void deploy(@NotNull AnActionEvent e) {
            this.doDeploy(e, DefaultRunExecutor.getRunExecutorInstance(), "Deploy Configuration", true);
        }

        public void deployWithDebug(@NotNull AnActionEvent e) {
            this.doDeploy(e, DefaultDebugExecutor.getDebugExecutorInstance(), "Deploy and Debug Configuration", false);
        }

        public void doDeploy(@NotNull AnActionEvent e, final Executor executor, String popupTitle, boolean canCreate) {
            RemoteServer<?> server = this.getServer();
            final ServerType serverType = server.getType();
            final DeploymentConfigurationManager configurationManager = DeploymentConfigurationManager.getInstance((Project)this.myProject);
            LinkedList runConfigsAndTypes = new LinkedList();
            List runConfigs = ContainerUtil.filter((Collection)configurationManager.getDeploymentConfigurations(serverType), settings -> {
                DeployToServerRunConfiguration configuration2 = (DeployToServerRunConfiguration)settings.getConfiguration();
                return StringUtil.equals((CharSequence)server.getName(), (CharSequence)configuration2.getServerName());
            });
            runConfigsAndTypes.addAll(runConfigs);
            if (canCreate) {
                runConfigsAndTypes.addAll(server.getType().getSingletonDeploymentSourceTypes());
                if (server.getType().mayHaveProjectSpecificDeploymentSources()) {
                    runConfigsAndTypes.add(null);
                }
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Object>(popupTitle, runConfigsAndTypes){

                public Icon getIconFor(Object runConfigOrSourceType) {
                    return runConfigOrSourceType != null ? serverType.getIcon() : null;
                }

                @NotNull
                public String getTextFor(Object runConfigOrSourceType) {
                    if (runConfigOrSourceType instanceof RunnerAndConfigurationSettings) {
                        return ((RunnerAndConfigurationSettings)runConfigOrSourceType).getName();
                    }
                    if (runConfigOrSourceType instanceof SingletonDeploymentSourceType) {
                        String displayName = ((SingletonDeploymentSourceType)runConfigOrSourceType).getPresentableName();
                        return CloudBundle.getText("create.new.deployment.configuration.for.singleton.type", displayName);
                    }
                    return CloudBundle.getText("create.new.deployment.configuration.generic", new Object[0]);
                }

                public PopupStep onChosen(Object selectedRunConfigOrSourceType, boolean finalChoice) {
                    return this.doFinalStep(() -> {
                        if (selectedRunConfigOrSourceType instanceof RunnerAndConfigurationSettings) {
                            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)selectedRunConfigOrSourceType, executor);
                        } else if (selectedRunConfigOrSourceType instanceof SingletonDeploymentSourceType) {
                            SingletonDeploymentSourceType sourceType = (SingletonDeploymentSourceType)selectedRunConfigOrSourceType;
                            configurationManager.createAndRunConfiguration(serverType, (RemoteServer)this.getValue(), (DeploymentSourceType)sourceType);
                        } else {
                            assert (selectedRunConfigOrSourceType == null);
                            configurationManager.createAndRunConfiguration(serverType, (RemoteServer)this.getValue(), null);
                        }
                    });
                }
            });
            if (e.getInputEvent() instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)e.getInputEvent()));
            } else {
                popup2.showInBestPositionFor(e.getDataContext());
            }
        }

        public void editConfiguration() {
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new SingleRemoteServerConfigurable((RemoteServer)this.getValue(), null, false));
        }

        @Nullable
        private Icon getStatusIcon(ConnectionStatus status) {
            switch (status) {
                case CONNECTED: {
                    return RemoteServersIcons.ResumeScaled;
                }
                case DISCONNECTED: {
                    return RemoteServersIcons.SuspendScaled;
                }
            }
            return null;
        }
    }

    private class ServersTreeRootNode
    extends AbstractTreeNode<Object> {
        ServersTreeRootNode() {
            super(ServersTreeStructure.this.doGetProject(), new Object());
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList result2 = new ArrayList();
            result2.addAll(ServersTreeStructure.this.myContribution.createServerNodes(ServersTreeStructure.this.doGetProject()));
            result2.addAll(ContainerUtil.map(ServersTreeStructure.this.myContribution.getRemoteServers(), server -> new RemoteServerNode(ServersTreeStructure.this.doGetProject(), (RemoteServer<?>)server, ServersTreeStructure.this::createDeploymentNode)));
            return result2;
        }

        protected void update(@NotNull PresentationData presentation) {
        }
    }

    public static interface LogProvidingNode {
        @Nullable
        public JComponent getComponent();

        @NotNull
        public String getLogId();
    }
}

