/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CloudDeploymentConfiguratorBase<D extends DeploymentConfiguration, S extends ServerConfiguration>
extends DeploymentConfigurator<D, S> {
    private final Project myProject;
    private final ServerType<S> myServerType;

    public CloudDeploymentConfiguratorBase(Project project, ServerType<S> serverType) {
        this.myProject = project;
        this.myServerType = serverType;
    }

    public static List<CloudDeploymentRuntimeProvider> getDeploymentRuntimeProviders(ServerType<?> serverType) {
        ArrayList<CloudDeploymentRuntimeProvider> result2 = new ArrayList<CloudDeploymentRuntimeProvider>();
        for (CloudDeploymentRuntimeProvider provider : (CloudDeploymentRuntimeProvider[])CloudDeploymentRuntimeProvider.EP_NAME.getExtensions()) {
            ServerType<?> providerServerType = provider.getServerType();
            if (providerServerType != null && providerServerType != serverType) continue;
            result2.add(provider);
        }
        return result2;
    }

    @NotNull
    public List<DeploymentSource> getAvailableDeploymentSources() {
        if (this.myProject.isDefault()) {
            return Collections.emptyList();
        }
        ArrayList<DeploymentSource> result2 = new ArrayList<DeploymentSource>();
        for (CloudDeploymentRuntimeProvider provider : CloudDeploymentConfiguratorBase.getDeploymentRuntimeProviders(this.myServerType)) {
            result2.addAll(provider.getDeploymentSources(this.myProject));
        }
        return result2;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }
}

