/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudGitAgentDeployment;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudLoggingHandlerImpl;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudSilentLoggingHandlerImpl;
import com.intellij.remoteServer.util.ServerRuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudGitApplicationRuntime
extends CloudApplicationRuntime {
    private final CloudMultiSourceServerRuntimeInstance myServerRuntime;
    private final DeploymentLogManager myLogManager;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private final CloudGitAgentDeployment myDeployment;

    public CloudGitApplicationRuntime(CloudMultiSourceServerRuntimeInstance serverRuntime, String applicationName, @Nullable DeploymentLogManager logManager) {
        super(applicationName);
        this.myServerRuntime = serverRuntime;
        this.myLogManager = logManager;
        this.myLoggingHandler = logManager == null ? new CloudSilentLoggingHandlerImpl() : new CloudLoggingHandlerImpl(logManager);
        this.myDeployment = serverRuntime.getAgent().createDeployment(applicationName, this.myLoggingHandler);
    }

    public CloudMultiSourceServerRuntimeInstance getServerRuntime() {
        return this.myServerRuntime;
    }

    public DeploymentLogManager getLogManager() {
        return this.myLogManager;
    }

    protected CloudAgentLoggingHandler getLoggingHandler() {
        return this.myLoggingHandler;
    }

    @Override
    public AgentTaskExecutor getAgentTaskExecutor() {
        return this.getServerRuntime().getAgentTaskExecutor();
    }

    @Override
    public ServerTaskExecutor getTaskExecutor() {
        return this.getServerRuntime().getTaskExecutor();
    }

    @Override
    protected ServerType<?> getCloudType() {
        return this.getServerRuntime().getCloudType();
    }

    public CloudGitAgentDeployment getDeployment() {
        return this.myDeployment;
    }

    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback2) {
        this.getTaskExecutor().submit(() -> {
            try {
                if (!this.confirmUndeploy()) {
                    throw new ServerRuntimeException("Undeploy cancelled");
                }
                this.undeploy();
                callback2.succeeded();
            }
            catch (ServerRuntimeException e) {
                callback2.errorOccurred(e.getMessage());
            }
        }, (RemoteOperationCallback)callback2);
    }

    public void undeploy() throws ServerRuntimeException {
        this.getAgentTaskExecutor().execute(() -> {
            this.getDeployment().deleteApplication();
            return null;
        });
    }

    private boolean confirmUndeploy() {
        Ref confirmed = new Ref((Object)false);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            String title = CloudBundle.getText("cloud.undeploy.confirm.title", new Object[0]);
            String password;
            while ((password = Messages.showPasswordDialog((String)CloudBundle.getText("cloud.undeploy.confirm.message", this.getApplicationName()), (String)title)) != null) {
                if (password.equals(this.getServerRuntime().getConfiguration().getPasswordSafe())) {
                    confirmed.set((Object)true);
                    return;
                }
                Messages.showErrorDialog((String)CloudBundle.getText("cloud.undeploy.confirm.password.incorrect", new Object[0]), (String)title);
            }
            return;
        });
        return (Boolean)confirmed.get();
    }
}

