/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudGitAgent;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudDeploymentConfiguratorBase;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import com.intellij.remoteServer.util.CloudGitApplicationRuntime;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudMultiSourceServerRuntimeInstance<DC extends CloudDeploymentNameConfiguration, AC extends CloudAgentConfigBase, A extends CloudGitAgent<AC, ?>, SC extends AC>
extends CloudServerRuntimeInstance<DC, A, SC> {
    private static final Logger LOG = Logger.getInstance(CloudMultiSourceServerRuntimeInstance.class);
    private final ServerType<?> myServerType;

    public CloudMultiSourceServerRuntimeInstance(ServerType<?> serverType, SC configuration2, ServerTaskExecutor tasksExecutor, List<File> libraries, List<Class<?>> commonJarClasses, String specificsModuleName, String specificJarPath, Class<A> agentInterface, String agentClassName) throws Exception {
        super(configuration2, tasksExecutor, libraries, commonJarClasses, specificsModuleName, specificJarPath, agentInterface, agentClassName);
        this.myServerType = serverType;
    }

    @Override
    public A getAgent() {
        return (A)((CloudGitAgent)super.getAgent());
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, @NotNull DC configuration2) {
        return CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER.getDeploymentName(source);
    }

    public void connect(final ServerConnector.ConnectionCallback<DC> callback2) {
        this.getAgentTaskExecutor().execute(() -> {
            this.doConnect(this.getConfiguration(), new CloudAgentLogger(){

                public void debugEx(Exception e) {
                    LOG.debug((Throwable)e);
                }

                public void debug(String message) {
                    LOG.debug(message);
                }
            });
            return null;
        }, new CallbackWrapper(){

            public void onSuccess(Object result2) {
                callback2.connected((ServerRuntimeInstance)CloudMultiSourceServerRuntimeInstance.this);
            }

            @Override
            public void onError(String message) {
                callback2.errorOccurred(message);
            }
        });
    }

    public void deploy(@NotNull DeploymentTask<DC> task2, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback2) {
        this.getTaskExecutor().submit(() -> this.createDeploymentRuntime(task2, logManager).deploy(callback2), (RemoteOperationCallback)callback2);
    }

    public void disconnect() {
        this.getTaskExecutor().submit(() -> this.getAgent().disconnect());
    }

    public CloudDeploymentRuntime createDeploymentRuntime(DeployToServerRunConfiguration<?, DC> runConfiguration) throws ServerRuntimeException {
        return this.createDeploymentRuntime(runConfiguration.getDeploymentSource(), (CloudDeploymentNameConfiguration)runConfiguration.getDeploymentConfiguration(), runConfiguration.getProject());
    }

    public CloudDeploymentRuntime createDeploymentRuntime(final DeploymentSource source, DC configuration2, Project project) throws ServerRuntimeException {
        return this.createDeploymentRuntime(new DeploymentTask<DC>((CloudDeploymentNameConfiguration)configuration2, project){
            final /* synthetic */ CloudDeploymentNameConfiguration val$configuration;
            final /* synthetic */ Project val$project;
            {
                this.val$configuration = cloudDeploymentNameConfiguration;
                this.val$project = project;
            }

            @NotNull
            public DeploymentSource getSource() {
                return source;
            }

            @NotNull
            public DC getConfiguration() {
                return this.val$configuration;
            }

            @NotNull
            public Project getProject() {
                return this.val$project;
            }

            public boolean isDebugMode() {
                return false;
            }

            @NotNull
            public ExecutionEnvironment getExecutionEnvironment() {
                throw new UnsupportedOperationException();
            }
        }, null);
    }

    private CloudDeploymentRuntime createDeploymentRuntime(DeploymentTask<DC> deploymentTask, @Nullable DeploymentLogManager logManager) throws ServerRuntimeException {
        DeploymentSource source = deploymentTask.getSource();
        for (CloudDeploymentRuntimeProvider provider : CloudDeploymentConfiguratorBase.getDeploymentRuntimeProviders(this.myServerType)) {
            CloudDeploymentRuntime result2 = provider.createDeploymentRuntime(source, this, deploymentTask, logManager);
            if (result2 == null) continue;
            return result2;
        }
        throw new ServerRuntimeException("Unknown deployment source");
    }

    @Override
    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication application) {
        return new CloudGitApplicationRuntime(this, application.getName(), null);
    }

    protected abstract void doConnect(SC var1, CloudAgentLogger var2);

    public ServerType<?> getCloudType() {
        return this.myServerType;
    }
}

