/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafEquality;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SliceLeafAnalyzer {
    private static final Logger LOG = Logger.getInstance(SliceLeafAnalyzer.class);
    @NotNull
    private final SliceLeafEquality myLeafEquality;
    @NotNull
    private final SliceLanguageSupportProvider myProvider;

    public SliceLeafAnalyzer(@NotNull SliceLeafEquality leafEquality, @NotNull SliceLanguageSupportProvider provider) {
        this.myLeafEquality = leafEquality;
        this.myProvider = provider;
    }

    public static SliceNode filterTree(SliceNode oldRoot, NullableFunction<? super SliceNode, ? extends SliceNode> filter, PairProcessor<? super SliceNode, ? super List<SliceNode>> postProcessor) {
        boolean success2;
        SliceNode filtered = (SliceNode)filter.fun((Object)oldRoot);
        if (filtered == null) {
            return null;
        }
        ArrayList<SliceNode> childrenFiltered = new ArrayList<SliceNode>();
        if (oldRoot.myCachedChildren != null) {
            for (SliceNode child2 : oldRoot.myCachedChildren) {
                SliceNode childFiltered = SliceLeafAnalyzer.filterTree(child2, filter, postProcessor);
                if (childFiltered == null) continue;
                childrenFiltered.add(childFiltered);
            }
        }
        boolean bl = success2 = postProcessor == null || postProcessor.process((Object)filtered, childrenFiltered);
        if (!success2) {
            return null;
        }
        filtered.myCachedChildren = new ArrayList<SliceNode>(childrenFiltered);
        return filtered;
    }

    private void groupByValues(@NotNull Collection<? extends PsiElement> leaves, @NotNull SliceRootNode oldRoot, @NotNull Map<SliceNode, Collection<PsiElement>> map2) {
        assert (oldRoot.myCachedChildren.size() == 1);
        SliceRootNode root = this.createTreeGroupedByValues(leaves, oldRoot, map2);
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceUsage rootUsage = (SliceUsage)((Object)oldRootStart.getValue());
        String description = SliceManager.getElementDescription(null, rootUsage.getElement(), " (grouped by value)");
        SliceManager.getInstance(root.getProject()).createToolWindow(true, root, true, description);
    }

    @NotNull
    public SliceRootNode createTreeGroupedByValues(@NotNull Collection<? extends PsiElement> leaves, @NotNull SliceRootNode oldRoot, @NotNull Map<SliceNode, Collection<PsiElement>> map2) {
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceRootNode root = oldRoot.copy();
        root.setChanged();
        root.targetEqualUsages.clear();
        ArrayList<SliceLeafValueRootNode> leafValueRoots = new ArrayList<SliceLeafValueRootNode>(leaves.size());
        for (PsiElement psiElement : leaves) {
            SliceNode newNode = SliceLeafAnalyzer.filterTree(oldRootStart, (NullableFunction<? super SliceNode, ? extends SliceNode>)((NullableFunction)oldNode -> {
                if (oldNode.getDuplicate() != null) {
                    return null;
                }
                if (!SliceLeafAnalyzer.node(oldNode, map2).contains(leafExpression)) {
                    return null;
                }
                return oldNode.copy();
            }), (PairProcessor<? super SliceNode, ? super List<SliceNode>>)((PairProcessor)(node, children2) -> {
                if (!children2.isEmpty()) {
                    return true;
                }
                PsiElement element = ((SliceUsage)((Object)((Object)((Object)node.getValue())))).getElement();
                if (element == null) {
                    return false;
                }
                return element.getManager().areElementsEquivalent(element, leafExpression);
            }));
            SliceLeafValueRootNode lvNode = new SliceLeafValueRootNode(root.getProject(), root, this.myProvider.createRootUsage(psiElement, ((SliceUsage)((Object)oldRoot.getValue())).params), Collections.singletonList(newNode));
            leafValueRoots.add(lvNode);
        }
        root.setChildren(leafValueRoots);
        return root;
    }

    public void startAnalyzeValues(final @NotNull AbstractTreeStructure treeStructure, final @NotNull Runnable finish) {
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, Collection<PsiElement>> map2 = this.createMap();
        String encouragementPiece = " (may very well take the whole day)";
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), "Expanding All Nodes..." + encouragementPiece, true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection<PsiElement> l = SliceLeafAnalyzer.this.calcLeafExpressions(root, treeStructure, map2);
                leafExpressions.set(l);
            }

            public void onCancel() {
                finish.run();
            }

            public void onSuccess() {
                try {
                    Collection leaves = (Collection)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    if (leaves.isEmpty()) {
                        Messages.showErrorDialog((String)"Unable to find leaf expressions to group by", (String)"Cannot Group");
                        return;
                    }
                    SliceLeafAnalyzer.this.groupByValues(leaves, root, map2);
                }
                finally {
                    finish.run();
                }
            }
        });
    }

    public Map<SliceNode, Collection<PsiElement>> createMap() {
        return ConcurrentFactoryMap.createMap(k -> ConcurrentCollectionFactory.createConcurrentSet(this.myLeafEquality), () -> ConcurrentCollectionFactory.createMap(ContainerUtil.identityStrategy()));
    }

    private static Collection<PsiElement> node(SliceNode node, Map<SliceNode, Collection<PsiElement>> map2) {
        return map2.get(node);
    }

    @NotNull
    public Collection<PsiElement> calcLeafExpressions(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, Collection<PsiElement>> map2) {
        final SliceNodeGuide guide = new SliceNodeGuide(treeStructure);
        final AtomicInteger depth = new AtomicInteger();
        final boolean printToLog = LOG.isTraceEnabled();
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void elementStarted(@NotNull SliceNode element) {
                depth.incrementAndGet();
                super.elementStarted((Object)element);
            }

            public void visit(@NotNull SliceNode element) {
                element.calculateDupNode();
                SliceLeafAnalyzer.node(element, map2).clear();
                SliceNode duplicate = element.getDuplicate();
                if (duplicate != null) {
                    SliceLeafAnalyzer.node(element, map2).addAll(SliceLeafAnalyzer.node(duplicate, map2));
                } else {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement value;
                        SliceUsage sliceUsage = (SliceUsage)((Object)((Object)element.getValue()));
                        Collection<SliceNode> children2 = element.getChildren();
                        if (printToLog) {
                            LOG.trace(StringUtil.repeat((String)"  ", (int)Math.max(depth.get(), 0)) + "analyzing usages of " + (Object)((Object)sliceUsage) + " (in " + (sliceUsage == null ? "null" : sliceUsage.getFile().getName() + ":" + sliceUsage.getLine()) + ")");
                        }
                        if (children2.isEmpty() && sliceUsage != null && sliceUsage.canBeLeaf() && (value = sliceUsage.getElement()) != null) {
                            SliceLeafAnalyzer.node(element, map2).addAll(ContainerUtil.singleton((Object)value, (TObjectHashingStrategy)SliceLeafAnalyzer.this.myLeafEquality));
                        }
                    });
                    super.visit((Object)element);
                }
            }

            public void elementFinished(@NotNull SliceNode element) {
                depth.decrementAndGet();
                SliceNode parent = guide.getParent(element);
                if (parent != null) {
                    SliceLeafAnalyzer.node(parent, map2).addAll(SliceLeafAnalyzer.node(element, map2));
                }
            }
        };
        walkingState.visit((Object)root);
        return SliceLeafAnalyzer.node(root, map2);
    }

    public static class SliceNodeGuide
    implements WalkingState.TreeGuide<SliceNode> {
        private final AbstractTreeStructure myTreeStructure;

        public SliceNodeGuide(@NotNull AbstractTreeStructure treeStructure) {
            this.myTreeStructure = treeStructure;
        }

        public SliceNode getNextSibling(@NotNull SliceNode element) {
            AbstractTreeNode parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return element.getNext((List)parent.getChildren());
        }

        public SliceNode getPrevSibling(@NotNull SliceNode element) {
            AbstractTreeNode parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return element.getPrev((List)parent.getChildren());
        }

        public SliceNode getFirstChild(@NotNull SliceNode element) {
            Object[] children2 = this.myTreeStructure.getChildElements((Object)element);
            return children2.length == 0 ? null : (SliceNode)children2[0];
        }

        public SliceNode getParent(@NotNull SliceNode element) {
            AbstractTreeNode parent = element.getParent();
            return parent instanceof SliceNode ? (SliceNode)parent : null;
        }
    }
}

