/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class SliceLeafValueRootNode
extends SliceNode
implements MyColoredTreeCellRenderer {
    public final List<SliceNode> myCachedChildren;

    public SliceLeafValueRootNode(@NotNull Project project, @NotNull SliceNode root, @NotNull SliceUsage sliceUsage, @NotNull List<SliceNode> children2) {
        super(project, sliceUsage, root.targetEqualUsages);
        this.myCachedChildren = children2;
    }

    @Override
    @NotNull
    public Collection<SliceNode> getChildren() {
        return this.myCachedChildren;
    }

    @Override
    public List<SliceNode> getCachedChildren() {
        return this.myCachedChildren;
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
    }

    @Override
    public String toString() {
        return this.getNodeText();
    }

    @Override
    public String getNodeText() {
        PsiElement element;
        SliceUsage value = (SliceUsage)((Object)this.getValue());
        String text = value != null ? ((element = value.getUsageInfo().getElement()) == null ? "" : element.getText()) : "Other";
        return "Value: " + text;
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer2, @NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        SliceUsage usage = (SliceUsage)((Object)this.getValue());
        renderer2.append("Value: ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (usage != null) {
            PsiElement element = usage.getElement();
            if (element == null) {
                renderer2.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SliceUsageCellRendererBase.ourInvalidAttributes);
            } else {
                SliceLeafValueRootNode.appendElementText(usage, element, renderer2);
            }
        } else {
            renderer2.append("Other", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    private static void appendElementText(@NotNull UsageInfo2UsageAdapter usage, @NotNull PsiElement element, @NotNull SliceUsageCellRendererBase renderer2) {
        PsiFile file2 = element.getContainingFile();
        ArrayList result2 = new ArrayList();
        ChunkExtractor.getExtractor((PsiFile)element.getContainingFile()).createTextChunks(usage, (CharSequence)file2.getText(), element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset(), false, result2);
        for (TextChunk chunk : result2) {
            renderer2.append(chunk.getText(), chunk.getSimpleAttributesIgnoreBackground());
        }
    }
}

