/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class SliceRootNode
extends SliceNode {
    private final SliceUsage myRootUsage;

    public SliceRootNode(@NotNull Project project, @NotNull DuplicateMap targetEqualUsages, @NotNull SliceUsage rootUsage) {
        super(project, LanguageSlicing.getProvider((PsiElement)rootUsage.getElement().getContainingFile()).createRootUsage((PsiElement)rootUsage.getElement().getContainingFile(), rootUsage.params), targetEqualUsages);
        this.myRootUsage = rootUsage;
    }

    private void switchToAllLeavesTogether(SliceUsage rootUsage) {
        SliceNode node = new SliceNode(this.getProject(), rootUsage, this.targetEqualUsages);
        this.myCachedChildren = Collections.singletonList(node);
    }

    @Override
    @NotNull
    public SliceRootNode copy() {
        SliceUsage newUsage = ((SliceUsage)((Object)this.getValue())).copy();
        SliceRootNode newNode = new SliceRootNode(this.getProject(), new DuplicateMap(), newUsage);
        newNode.dupNodeCalculated = this.dupNodeCalculated;
        newNode.duplicate = this.duplicate;
        return newNode;
    }

    @Override
    @NotNull
    public Collection<SliceNode> getChildren() {
        if (this.myCachedChildren == null) {
            this.switchToAllLeavesTogether(this.myRootUsage);
        }
        return this.myCachedChildren;
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer2, @NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
    }

    @NotNull
    public SliceUsage getRootUsage() {
        return this.myRootUsage;
    }

    public void setChildren(@NotNull List<? extends SliceNode> children2) {
        this.myCachedChildren = new ArrayList<SliceNode>(children2);
    }
}

