/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.engine.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BaseSuggestionProvider
implements SuggestionProvider {
    private final SpellCheckerManager manager;

    public BaseSuggestionProvider(@NotNull SpellCheckerManager manager) {
        this.manager = manager;
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String text) {
        String[] words = NameUtil.nameToWords((String)text);
        int index = 0;
        List[] res2 = new List[words.length];
        int i = 0;
        for (String word : words) {
            List<Object> variants;
            int start2 = text.indexOf(word, index);
            int end = start2 + word.length();
            if (this.manager.hasProblem(word)) {
                variants = this.manager.getRawSuggestions(word);
                res2[i++] = variants;
            } else {
                variants = new ArrayList();
                variants.add(word);
                res2[i++] = variants;
            }
            index = end;
        }
        int[] counter = new int[i];
        int size = 1;
        for (int j = 0; j < i; ++j) {
            size *= res2[j].size();
        }
        String[] all = new String[size];
        for (int k = 0; k < size; ++k) {
            for (int j = 0; j < i; ++j) {
                if (all[k] == null) {
                    all[k] = "";
                }
                int n = k;
                all[n] = all[n] + res2[j].get(counter[j]);
                int n2 = j;
                counter[n2] = counter[n2] + 1;
                if (counter[j] < res2[j].size()) continue;
                counter[j] = 0;
            }
        }
        return Arrays.asList(all);
    }
}

