/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.project.ProjectKt;
import com.intellij.spellchecker.BaseSuggestionProvider;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.dictionary.AggregatedDictionary;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SpellCheckerFactory;
import com.intellij.spellchecker.engine.SuggestionProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.state.CachedDictionaryState;
import com.intellij.spellchecker.state.DictionaryStateListener;
import com.intellij.spellchecker.state.ProjectDictionaryState;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.spellchecker.util.Strings;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.SpellCheckerManager");
    private static final int MAX_METRICS = 1;
    public static final String PROJECT = "project";
    public static final String APP = "application";
    private final Project project;
    private SpellCheckerEngine spellChecker;
    private ProjectDictionary myProjectDictionary;
    private EditableDictionary myAppDictionary;
    private final SuggestionProvider suggestionProvider = new BaseSuggestionProvider(this);
    private final SpellCheckerSettings settings;
    private final VirtualFileListener myCustomDictFileListener;
    private final String myProjectDictinaryPath;
    private final String myAppDictionaryPath;
    public static final String PROJECT_DICTIONARY_PATH = "dictionaries" + File.separator + System.getProperty("user.name").replace('.', '_') + ".xml";
    public static final String CACHED_DICTIONARY_FILE = "cachedDictionary.xml";
    private final EventDispatcher<DictionaryStateListener> myUserDictionaryListenerEventDispatcher = EventDispatcher.create(DictionaryStateListener.class);

    public static SpellCheckerManager getInstance(Project project) {
        return (SpellCheckerManager)ServiceManager.getService((Project)project, SpellCheckerManager.class);
    }

    public SpellCheckerManager(Project project, SpellCheckerSettings settings) {
        this.project = project;
        this.settings = settings;
        this.fullConfigurationReload();
        Disposer.register((Disposable)project, (Disposable)this);
        VirtualFile projectStoreDir = project.getBaseDir() != null ? ProjectKt.getProjectStoreDirectory(project.getBaseDir()) : null;
        this.myProjectDictinaryPath = projectStoreDir != null ? projectStoreDir.getPath() + File.separator + PROJECT_DICTIONARY_PATH : "";
        this.myAppDictionaryPath = PathManager.getOptionsPath() + File.separator + CACHED_DICTIONARY_FILE;
        this.myCustomDictFileListener = new CustomDictFileListener(settings);
        LocalFileSystem.getInstance().addVirtualFileListener(this.myCustomDictFileListener);
    }

    public SpellCheckerEngine getSpellChecker() {
        return this.spellChecker;
    }

    public void fullConfigurationReload() {
        this.spellChecker = SpellCheckerFactory.create(this.project);
        this.fillEngineDictionary();
    }

    public void updateBundledDictionaries(List<String> removedDictionaries) {
        for (Object provider : BundledDictionaryProvider.EP_NAME.getExtensionList()) {
            for (String dictionary : provider.getBundledDictionaries()) {
                boolean dictionaryShouldBeLoad = this.settings == null || !this.settings.getBundledDisabledDictionariesPaths().contains(dictionary);
                boolean dictionaryIsLoad = this.spellChecker.isDictionaryLoad(dictionary);
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    this.spellChecker.removeDictionary(dictionary);
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                this.loadBundledDictionary((BundledDictionaryProvider)provider, dictionary);
            }
        }
        if (this.settings != null && this.settings.getCustomDictionariesPaths() != null) {
            Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String dictionary : this.settings.getCustomDictionariesPaths()) {
                boolean dictionaryShouldBeLoad = !disabledDictionaries.contains(dictionary);
                boolean dictionaryIsLoad = this.spellChecker.isDictionaryLoad(dictionary);
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    this.spellChecker.removeDictionary(dictionary);
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                this.loadDictionary(dictionary);
            }
        }
        if (!ContainerUtil.isEmpty(removedDictionaries)) {
            for (String name : removedDictionaries) {
                this.spellChecker.removeDictionary(name);
            }
        }
        SpellCheckerManager.restartInspections();
    }

    public Project getProject() {
        return this.project;
    }

    @NotNull
    public Set<String> getUserDictionaryWords() {
        return ContainerUtil.union(this.myProjectDictionary.getEditableWords(), this.myAppDictionary.getEditableWords());
    }

    @Deprecated
    public EditableDictionary getUserDictionary() {
        return new AggregatedDictionary(this.myProjectDictionary, this.myAppDictionary);
    }

    private void fillEngineDictionary() {
        this.spellChecker.reset();
        for (BundledDictionaryProvider provider : BundledDictionaryProvider.EP_NAME.getExtensionList()) {
            for (String dictionary : provider.getBundledDictionaries()) {
                if (this.settings != null && this.settings.getBundledDisabledDictionariesPaths().contains(dictionary)) continue;
                this.loadBundledDictionary(provider, dictionary);
            }
        }
        if (this.settings != null && this.settings.getCustomDictionariesPaths() != null) {
            Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String dictionary : this.settings.getCustomDictionariesPaths()) {
                if (disabledDictionaries.contains(dictionary)) continue;
                this.loadDictionary(dictionary);
            }
        }
        this.initUserDictionaries();
    }

    private void initUserDictionaries() {
        CachedDictionaryState cachedDictionaryState = (CachedDictionaryState)ServiceManager.getService((Project)this.project, CachedDictionaryState.class);
        cachedDictionaryState.addCachedDictListener(dict -> SpellCheckerManager.restartInspections());
        if (cachedDictionaryState.getDictionary() == null) {
            cachedDictionaryState.setDictionary(new UserDictionary("cached"));
        }
        this.myAppDictionary = cachedDictionaryState.getDictionary();
        this.spellChecker.addModifiableDictionary(this.myAppDictionary);
        ProjectDictionaryState dictionaryState = (ProjectDictionaryState)ServiceManager.getService((Project)this.project, ProjectDictionaryState.class);
        dictionaryState.addProjectDictListener(dict -> SpellCheckerManager.restartInspections());
        this.myProjectDictionary = dictionaryState.getProjectDictionary();
        this.myProjectDictionary.setActiveName(System.getProperty("user.name"));
        this.spellChecker.addModifiableDictionary(this.myProjectDictionary);
    }

    private void loadDictionary(@NotNull String path) {
        CustomDictionaryProvider dictionaryProvider = SpellCheckerManager.findApplicable(path);
        if (dictionaryProvider != null) {
            Dictionary dictionary = dictionaryProvider.get(path);
            if (dictionary != null) {
                this.spellChecker.addDictionary(dictionary);
            }
        } else {
            this.spellChecker.loadDictionary(new FileLoader(path));
        }
    }

    private void loadBundledDictionary(@NotNull BundledDictionaryProvider provider, @NotNull String dictionary) {
        Class<?> loaderClass = provider.getClass();
        InputStream stream = loaderClass.getResourceAsStream(dictionary);
        if (stream != null) {
            this.spellChecker.loadDictionary(new StreamLoader(stream, dictionary));
        } else {
            LOG.warn("Couldn't load dictionary '" + dictionary + "' with loader '" + loaderClass + "'");
        }
    }

    public boolean hasProblem(@NotNull String word) {
        return !this.spellChecker.isCorrect(word);
    }

    public void acceptWordAsCorrect(@NotNull String word, Project project) {
        this.acceptWordAsCorrect(word, null, project, DictionaryLevel.PROJECT);
    }

    public void acceptWordAsCorrect(@NotNull String word, @Nullable VirtualFile file2, @NotNull Project project, @NotNull DictionaryLevel dictionaryLevel) {
        EditableDictionary dictionary;
        if (DictionaryLevel.NOT_SPECIFIED == dictionaryLevel) {
            return;
        }
        final String transformed = this.spellChecker.getTransformation().transform(word);
        EditableDictionary editableDictionary = dictionary = DictionaryLevel.PROJECT == dictionaryLevel ? this.myProjectDictionary : this.myAppDictionary;
        if (transformed != null) {
            if (file2 != null) {
                WriteCommandAction.writeCommandAction((Project)project).run(() -> UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{file2}){

                    public void undo() {
                        SpellCheckerManager.this.removeWordFromDictionary(dictionary, transformed);
                    }

                    public void redo() {
                        SpellCheckerManager.this.addWordToDictionary(dictionary, transformed);
                    }
                }));
            }
            this.addWordToDictionary(dictionary, transformed);
        }
    }

    private void addWordToDictionary(@NotNull EditableDictionary dictionary, @NotNull String word) {
        dictionary.addToDictionary(word);
        this.fireDictionaryChanged(dictionary);
    }

    private void removeWordFromDictionary(@NotNull EditableDictionary dictionary, String transformed) {
        dictionary.removeFromDictionary(transformed);
        this.fireDictionaryChanged(dictionary);
    }

    private void fireDictionaryChanged(@NotNull EditableDictionary dictionary) {
        ((DictionaryStateListener)this.myUserDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(dictionary);
        SpellCheckerManager.restartInspections();
        this.project.save();
    }

    public void updateUserDictionary(@NotNull Collection<String> words) {
        Collection addedToProjectWords = ContainerUtil.subtract(words, this.getUserDictionaryWords());
        addedToProjectWords.forEach(this.myProjectDictionary::addToDictionary);
        Collection deletedFromProjectWords = ContainerUtil.subtract(this.myProjectDictionary.getEditableWords(), words);
        deletedFromProjectWords.forEach(this.myProjectDictionary::removeFromDictionary);
        if (addedToProjectWords.size() + deletedFromProjectWords.size() > 0) {
            ((DictionaryStateListener)this.myUserDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(this.myProjectDictionary);
        }
        Collection deletedFromApplicationWords = ContainerUtil.subtract(this.myAppDictionary.getEditableWords(), words);
        deletedFromApplicationWords.forEach(this.myAppDictionary::removeFromDictionary);
        if (deletedFromApplicationWords.size() > 0) {
            ((DictionaryStateListener)this.myUserDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(this.myAppDictionary);
        }
        SpellCheckerManager.restartInspections();
    }

    @NotNull
    public static List<String> getBundledDictionaries() {
        ArrayList<String> dictionaries = new ArrayList<String>();
        for (BundledDictionaryProvider provider : BundledDictionaryProvider.EP_NAME.getExtensionList()) {
            ContainerUtil.addAll(dictionaries, (Object[])provider.getBundledDictionaries());
        }
        return dictionaries;
    }

    @NotNull
    public List<String> getSuggestions(@NotNull String text) {
        return this.suggestionProvider.getSuggestions(text);
    }

    @NotNull
    protected List<String> getRawSuggestions(@NotNull String word) {
        ArrayList<String> suggestions;
        if (!this.spellChecker.isCorrect(word) && !(suggestions = this.spellChecker.getSuggestions(word, this.settings.getCorrectionsLimit(), 1)).isEmpty()) {
            if (Strings.isCapitalized(word)) {
                Strings.capitalize(suggestions);
            } else if (Strings.isUpperCase(word)) {
                Strings.upperCase(suggestions);
            }
            LinkedHashSet<String> unique = new LinkedHashSet<String>(suggestions);
            return unique.size() < suggestions.size() ? new ArrayList<String>(unique) : suggestions;
        }
        return Collections.emptyList();
    }

    public static void restartInspections() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project[] projects;
            for (Project project1 : projects = ProjectManager.getInstance().getOpenProjects()) {
                if (!project1.isInitialized() || !project1.isOpen() || project1.isDefault()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project1).restart();
            }
        });
    }

    @Nullable
    private static CustomDictionaryProvider findApplicable(@NotNull String path) {
        return CustomDictionaryProvider.EP_NAME.getExtensionList().stream().filter(dictionaryProvider -> dictionaryProvider.isApplicable(path)).findAny().orElse(null);
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myCustomDictFileListener);
    }

    @NotNull
    public String getProjectDictionaryPath() {
        return this.myProjectDictinaryPath;
    }

    @NotNull
    public String getAppDictionaryPath() {
        return this.myAppDictionaryPath;
    }

    public void openDictionaryInEditor(@NotNull String dictPath) {
        VirtualFile file2;
        VirtualFile virtualFile = file2 = StringUtil.isEmpty((String)dictPath) ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(dictPath);
        if (file2 == null) {
            String title = SpellCheckerBundle.message("dictionary.not.found.title", new Object[0]);
            String message = SpellCheckerBundle.message("dictionary.not.found", dictPath);
            Messages.showMessageDialog((Project)this.project, (String)message, (String)title, (Icon)Messages.getWarningIcon());
            return;
        }
        FileEditorManager fileManager = FileEditorManager.getInstance((Project)this.project);
        if (fileManager != null) {
            fileManager.openFile(file2, true);
        }
    }

    public void addUserDictionaryChangedListener(DictionaryStateListener listener2, Disposable parentDisposable) {
        this.myUserDictionaryListenerEventDispatcher.addListener((EventListener)listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myUserDictionaryListenerEventDispatcher.removeListener((EventListener)listener2));
    }

    private class CustomDictFileListener
    implements VirtualFileListener {
        private final SpellCheckerSettings mySettings;

        CustomDictFileListener(SpellCheckerSettings settings) {
            this.mySettings = settings;
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            this.removeCustomDictionaries(event.getFile().getPath());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            this.loadCustomDictionaries(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            String oldPath = event.getOldParent().getPath() + File.separator + event.getFileName();
            if (!this.affectCustomDicts(oldPath)) {
                this.loadCustomDictionaries(event.getFile());
            } else {
                String newPath = event.getNewParent().getPath() + File.separator + event.getFileName();
                if (!this.affectCustomDicts(newPath)) {
                    this.removeCustomDictionaries(oldPath);
                }
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            String path = FileUtilRt.toSystemDependentName((String)event.getFile().getPath());
            if (!SpellCheckerManager.this.spellChecker.isDictionaryLoad(path) || this.mySettings.getDisabledDictionariesPaths().contains(path)) {
                return;
            }
            SpellCheckerManager.this.spellChecker.removeDictionary(path);
            SpellCheckerManager.this.loadDictionary(path);
            SpellCheckerManager.restartInspections();
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file2 = event.getFile();
            if (file2.isDirectory()) {
                return;
            }
            if ("name".equals(event.getPropertyName())) {
                String oldName = (String)event.getOldValue();
                if (!this.isDic(oldName)) {
                    this.loadCustomDictionaries(file2);
                } else {
                    String newName = (String)event.getNewValue();
                    if (!this.isDic(newName)) {
                        this.removeCustomDictionaries(file2.getParent().getPath() + File.separator + oldName);
                    }
                }
            }
        }

        private void removeCustomDictionaries(@NotNull String path) {
            String systemDependentPath = FileUtilRt.toSystemDependentName((String)path);
            if (this.affectCustomDicts(path)) {
                SpellCheckerManager.this.spellChecker.removeDictionariesRecursively(systemDependentPath);
                this.mySettings.getCustomDictionariesPaths().removeIf(dict -> FileUtil.isAncestor((String)systemDependentPath, (String)dict, (boolean)false));
                this.mySettings.getDisabledDictionariesPaths().removeIf(dict -> FileUtil.isAncestor((String)systemDependentPath, (String)dict, (boolean)false));
                SpellCheckerManager.restartInspections();
            }
        }

        private void loadCustomDictionaries(@NotNull VirtualFile file2) {
            String path = FileUtilRt.toSystemDependentName((String)file2.getPath());
            if (!this.affectCustomDicts(path)) {
                return;
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    boolean isDirectory = file2.isDirectory();
                    String path = file2.getPath();
                    if (!isDirectory && CustomDictFileListener.this.mySettings.getCustomDictionariesPaths().contains(path)) {
                        SpellCheckerManager.this.loadDictionary(path);
                        SpellCheckerManager.restartInspections();
                    }
                    return isDirectory;
                }
            });
        }

        private boolean isDic(String path) {
            return FileUtilRt.extensionEquals((String)path, (String)"dic");
        }

        private boolean affectCustomDicts(@NotNull String path) {
            return this.mySettings.getCustomDictionariesPaths().stream().anyMatch(dicPath -> FileUtil.isAncestor((String)path, (String)dicPath, (boolean)false));
        }
    }

    public static enum DictionaryLevel {
        APP("application-level"),
        PROJECT("project-level"),
        NOT_SPECIFIED("not specified");

        private final String myName;
        private static final Map<String, DictionaryLevel> DICTIONARY_LEVELS;

        private DictionaryLevel(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        @NotNull
        public static DictionaryLevel getLevelByName(@NotNull String name) {
            return DICTIONARY_LEVELS.getOrDefault(name, NOT_SPECIFIED);
        }

        static {
            DICTIONARY_LEVELS = Maps.uniqueIndex(EnumSet.allOf(DictionaryLevel.class), DictionaryLevel::getName);
        }
    }
}

