/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class AggregatedDictionary
implements EditableDictionary {
    @NonNls
    private static final String DICTIONARY_NAME = "common";
    private final EditableDictionary cachedDictionary;
    private final ProjectDictionary projectDictionary;

    @Override
    @NotNull
    public String getName() {
        return DICTIONARY_NAME;
    }

    public AggregatedDictionary(@NotNull ProjectDictionary projectDictionary, @NotNull EditableDictionary cachedDictionary) {
        this.projectDictionary = projectDictionary;
        this.cachedDictionary = cachedDictionary;
        this.cachedDictionary.addToDictionary(projectDictionary.getWords());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @NonNls
    public String toString() {
        return "AggregatedDictionary{cachedDictionary=" + this.cachedDictionary + ", projectDictionary=" + this.projectDictionary + '}';
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        return this.cachedDictionary.contains(word);
    }

    @Override
    public void addToDictionary(String word) {
        this.getProjectDictionary().addToDictionary(word);
        this.getCachedDictionary().addToDictionary(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        this.getProjectDictionary().removeFromDictionary(word);
        this.getCachedDictionary().removeFromDictionary(word);
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        Set<String> oldWords = this.getProjectDictionary().getWords();
        this.getProjectDictionary().replaceAll(words);
        this.getCachedDictionary().addToDictionary(words);
        for (String word : oldWords) {
            if (words != null && words.contains(word)) continue;
            this.getCachedDictionary().removeFromDictionary(word);
        }
    }

    @Override
    public void clear() {
        this.getProjectDictionary().clear();
    }

    @Override
    public void traverse(@NotNull Consumer<String> consumer) {
        this.cachedDictionary.traverse(consumer);
    }

    @Override
    public void getSuggestions(@NotNull String word, @NotNull Consumer<String> consumer) {
        this.traverse((Consumer<String>)((Consumer)s -> {
            if (!StringUtil.isEmpty((String)s) && s.charAt(0) == word.charAt(0) && s.length() >= 0 && s.length() <= Integer.MAX_VALUE) {
                consumer.consume(s);
            }
        }));
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        return this.cachedDictionary.getWords();
    }

    @Override
    public int size() {
        return this.cachedDictionary.size();
    }

    @Override
    @NotNull
    public Set<String> getEditableWords() {
        return this.getProjectDictionary().getEditableWords();
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        this.getProjectDictionary().addToDictionary(words);
        this.getCachedDictionary().addToDictionary(words);
    }

    public EditableDictionary getCachedDictionary() {
        return this.cachedDictionary;
    }

    public ProjectDictionary getProjectDictionary() {
        return this.projectDictionary;
    }
}

