/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.engine;

import com.google.common.collect.MinMaxPriorityQueue;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.spellchecker.compress.CompressedDictionary;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.Suggestion;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.EditDistance;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSpellChecker
implements SpellCheckerEngine {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.engine.BaseSpellChecker");
    private final Transformation transform = new Transformation();
    private final Set<EditableDictionary> dictionaries = new HashSet<EditableDictionary>();
    private final List<Dictionary> bundledDictionaries = ContainerUtil.createLockFreeCopyOnWriteList();
    private final AtomicBoolean myLoadingDictionaries = new AtomicBoolean(false);
    private final List<Pair<Loader, Consumer<? super Dictionary>>> myDictionariesToLoad = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Project myProject;

    public BaseSpellChecker(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    public void loadDictionary(@NotNull Loader loader) {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.addDictionary(CompressedDictionary.create(loader, this.transform));
        } else {
            this.loadDictionaryAsync(loader, (Consumer<? super Dictionary>)((Consumer)this::addDictionary));
        }
    }

    private void loadDictionaryAsync(@NotNull Loader loader, @NotNull Consumer<? super Dictionary> consumer) {
        if (this.myLoadingDictionaries.compareAndSet(false, true)) {
            LOG.debug("Loading " + loader.getName());
            this.doLoadDictionaryAsync(loader, consumer);
        } else {
            this.queueDictionaryLoad(loader, consumer);
        }
    }

    private void doLoadDictionaryAsync(Loader loader, Consumer<? super Dictionary> consumer) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            LOG.debug("Loading " + loader.getName());
            Application app = ApplicationManager.getApplication();
            app.executeOnPooledThread(() -> {
                if (app.isDisposed()) {
                    return;
                }
                CompressedDictionary dictionary = CompressedDictionary.create(loader, this.transform);
                LOG.debug(loader.getName() + " loaded!");
                consumer.consume((Object)dictionary);
                while (!this.myDictionariesToLoad.isEmpty()) {
                    if (app.isDisposed()) {
                        return;
                    }
                    Pair<Loader, Consumer<? super Dictionary>> nextDictionary = this.myDictionariesToLoad.remove(0);
                    Loader nextDictionaryLoader = (Loader)nextDictionary.getFirst();
                    dictionary = CompressedDictionary.create(nextDictionaryLoader, this.transform);
                    LOG.debug(nextDictionaryLoader.getName() + " loaded!");
                    ((Consumer)nextDictionary.getSecond()).consume((Object)dictionary);
                }
                LOG.debug("Loading finished, restarting daemon...");
                this.myLoadingDictionaries.set(false);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (app.isDisposed()) {
                        return;
                    }
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        DaemonCodeAnalyzer instance;
                        if (!project.isInitialized() || !project.isOpen() || project.isDefault() || (instance = DaemonCodeAnalyzer.getInstance((Project)project)) == null) continue;
                        instance.restart();
                    }
                });
            });
        });
    }

    private void queueDictionaryLoad(Loader loader, Consumer<? super Dictionary> consumer) {
        LOG.debug("Queuing load for: " + loader.getName());
        this.myDictionariesToLoad.add((Pair<Loader, Consumer<? super Dictionary>>)Pair.create((Object)loader, consumer));
    }

    @Override
    public void addModifiableDictionary(@NotNull EditableDictionary dictionary) {
        this.dictionaries.add(dictionary);
    }

    @Override
    public void addDictionary(@NotNull Dictionary dictionary) {
        this.bundledDictionaries.add(dictionary);
    }

    @Override
    public Transformation getTransformation() {
        return this.transform;
    }

    private static int isCorrect(@NotNull String transformed, @Nullable Collection<? extends Dictionary> dictionaries) {
        if (dictionaries == null) {
            return -1;
        }
        int errors = 0;
        for (Dictionary dictionary : dictionaries) {
            if (dictionary == null) continue;
            Boolean contains = dictionary.contains(transformed);
            if (contains == null) {
                ++errors;
                continue;
            }
            if (!contains.booleanValue()) continue;
            return 0;
        }
        if (errors == dictionaries.size()) {
            return errors;
        }
        return -1;
    }

    @Override
    public boolean isCorrect(@NotNull String word) {
        String transformed = this.transform.transform(word);
        if (this.myLoadingDictionaries.get() || transformed == null) {
            return true;
        }
        int bundled = BaseSpellChecker.isCorrect(transformed, this.bundledDictionaries);
        int user = BaseSpellChecker.isCorrect(transformed, this.dictionaries);
        return bundled == 0 || user == 0 || bundled > 0 && user > 0;
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String word, int maxSuggestions, int quality) {
        String transformed = this.transform.transform(word);
        if (transformed == null || maxSuggestions < 1) {
            return Collections.emptyList();
        }
        MinMaxPriorityQueue suggestions = MinMaxPriorityQueue.orderedBy(Suggestion::compareTo).maximumSize(maxSuggestions).create();
        for (Dictionary dict : ContainerUtil.concat((Iterable[])new Iterable[]{this.bundledDictionaries, this.dictionaries})) {
            dict.getSuggestions(transformed, (Consumer<String>)((Consumer)s -> suggestions.add((Object)new Suggestion((String)s, EditDistance.optimalAlignment((CharSequence)transformed, (CharSequence)s, (boolean)true)))));
        }
        if (suggestions.isEmpty()) {
            return Collections.emptyList();
        }
        int bestMetrics = ((Suggestion)suggestions.peek()).getMetrics();
        return suggestions.stream().filter(i -> bestMetrics - i.getMetrics() < quality).sorted().map(Suggestion::getWord).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<String> getVariants(@NotNull String prefix) {
        return Collections.emptyList();
    }

    @Override
    public void reset() {
        this.bundledDictionaries.clear();
        this.dictionaries.clear();
    }

    @Override
    public boolean isDictionaryLoad(@NotNull String name) {
        return this.getBundledDictionaryByName(name) != null;
    }

    @Override
    public void removeDictionary(@NotNull String name) {
        Dictionary dictionaryByName = this.getBundledDictionaryByName(name);
        if (dictionaryByName != null) {
            this.bundledDictionaries.remove(dictionaryByName);
        }
    }

    @Override
    public void removeDictionariesRecursively(@NotNull String directory) {
        this.bundledDictionaries.stream().map(Dictionary::getName).filter(dict -> FileUtil.isAncestor((String)directory, (String)dict, (boolean)false) && this.isDictionaryLoad((String)dict)).forEach(this::removeDictionary);
    }

    @Nullable
    public Dictionary getBundledDictionaryByName(@NotNull String name) {
        for (Dictionary dictionary : this.bundledDictionaries) {
            if (!name.equals(dictionary.getName())) continue;
            return dictionary;
        }
        return null;
    }
}

