/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSplitter
implements Splitter {
    public static final int MIN_RANGE_LENGTH = 3;

    protected static void addWord(@NotNull Consumer<? super TextRange> consumer, boolean ignore, @Nullable TextRange found) {
        boolean tooShort;
        if (found == null || ignore) {
            return;
        }
        boolean bl = tooShort = found.getEndOffset() - found.getStartOffset() <= 3;
        if (tooShort) {
            return;
        }
        consumer.consume((Object)found);
    }

    protected static boolean isAllWordsAreUpperCased(@NotNull String text, @NotNull List<? extends TextRange> words) {
        for (TextRange textRange : words) {
            StringCharacterIterator it = new StringCharacterIterator(text, textRange.getStartOffset(), textRange.getEndOffset(), textRange.getStartOffset());
            char c = it.first();
            while (c != '\uffff') {
                if (!Character.isUpperCase(c)) {
                    return false;
                }
                c = it.next();
            }
        }
        return true;
    }

    protected static boolean containsShortWord(@NotNull List<? extends TextRange> words) {
        for (TextRange textRange : words) {
            if (textRange.getLength() >= 3) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range2, @NotNull Matcher matcher) {
        return BaseSplitter.subRange(range2, matcher.start(), matcher.end());
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range2, @NotNull Matcher matcher, int group) {
        return BaseSplitter.subRange(range2, matcher.start(group), matcher.end(group));
    }

    @NotNull
    protected static TextRange subRange(@NotNull TextRange range2, int start2, int end) {
        return TextRange.from((int)(range2.getStartOffset() + start2), (int)(end - start2));
    }

    protected static boolean badSize(int from, int till) {
        int l = till - from;
        return l <= 3;
    }

    @NotNull
    protected static List<TextRange> excludeByPattern(String text, TextRange range2, @NotNull Pattern toExclude, int groupToInclude) {
        SmartList toCheck = new SmartList();
        int from = range2.getStartOffset();
        boolean addLast = true;
        try {
            int till;
            Matcher matcher = toExclude.matcher(BaseSplitter.newBombedCharSequence(text, range2));
            while (matcher.find()) {
                TextRange contentFound;
                BaseSplitter.checkCancelled();
                TextRange found = BaseSplitter.matcherRange(range2, matcher);
                till = found.getStartOffset();
                if (range2.getEndOffset() - found.getEndOffset() < 3) {
                    addLast = false;
                }
                if (!BaseSplitter.badSize(from, till)) {
                    toCheck.add(new TextRange(from, till));
                }
                if (groupToInclude > 0 && BaseSplitter.badSize((contentFound = BaseSplitter.matcherRange(range2, matcher, groupToInclude)).getEndOffset(), contentFound.getStartOffset())) {
                    toCheck.add(TextRange.create((Segment)contentFound));
                }
                from = found.getEndOffset();
            }
            till = range2.getEndOffset();
            if (BaseSplitter.badSize(from, till)) {
                return toCheck;
            }
            if (addLast) {
                toCheck.add(new TextRange(from, till));
            }
            return toCheck;
        }
        catch (ProcessCanceledException e) {
            return Collections.singletonList(range2);
        }
    }

    protected static CharSequence newBombedCharSequence(String text, TextRange range2) {
        return BaseSplitter.newBombedCharSequence(range2.substring(text));
    }

    protected static CharSequence newBombedCharSequence(String substring) {
        final long myTime = System.currentTimeMillis() + 500L;
        return new StringUtil.BombedCharSequence(substring){

            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    public static void checkCancelled() {
        if (ApplicationManager.getApplication() != null) {
            ProgressIndicatorProvider.checkCanceled();
        }
    }
}

