/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AcceptWordAsCorrect
implements SpellCheckerQuickFix {
    private String myWord;

    public AcceptWordAsCorrect(String word) {
        this.myWord = word;
    }

    public AcceptWordAsCorrect() {
    }

    @NotNull
    public String getName() {
        return this.myWord != null ? SpellCheckerBundle.message("add.0.to.dictionary", this.myWord) : SpellCheckerBundle.message("add.to.dictionary", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return SpellCheckerBundle.message("add.to.dictionary", new Object[0]);
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        return Anchor.LAST;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        SpellCheckerManager spellCheckerManager = SpellCheckerManager.getInstance(project);
        if (this.myWord != null) {
            spellCheckerManager.acceptWordAsCorrect(this.myWord, project);
        } else {
            spellCheckerManager.acceptWordAsCorrect(ProblemDescriptorUtil.extractHighlightedText((CommonProblemDescriptor)descriptor, descriptor.getPsiElement()), project);
        }
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }
}

