/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import icons.SpellcheckerIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShowSuggestions
implements LocalQuickFix,
Iconable {
    private List<String> suggestions;
    private boolean processed;
    private final String myWordWithTypo;

    public ShowSuggestions(String wordWithTypo) {
        this.myWordWithTypo = wordWithTypo;
    }

    @NotNull
    public List<String> getSuggestions(Project project) {
        if (!this.processed) {
            this.suggestions = SpellCheckerManager.getInstance(project).getSuggestions(this.myWordWithTypo);
            this.processed = true;
        }
        return this.suggestions;
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    @Nullable
    protected Editor getEditor(PsiElement element, @NotNull Project project) {
        return InjectedLanguageUtil.findInjectionHost(element) != null ? InjectedLanguageUtil.openEditorFor(element.getContainingFile(), project) : FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

