/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.settings.SpellCheckerSettingsPane;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckerSettingsManager
implements SearchableConfigurable,
Configurable.NoScroll {
    private SpellCheckerSettingsPane settingsPane;
    private final SpellCheckerSettings settings;
    private final Project project;

    public SpellCheckerSettingsManager(Project project, SpellCheckerSettings settings) {
        this.project = project;
        this.settings = settings;
    }

    @Nls
    public String getDisplayName() {
        return SpellCheckerBundle.message("spelling", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.ide.settings.spelling";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    public JComponent createComponent() {
        if (this.settingsPane == null) {
            this.settingsPane = new SpellCheckerSettingsPane(this.settings, this.project);
        }
        return this.settingsPane.getPane();
    }

    public boolean isModified() {
        return this.settingsPane == null || this.settingsPane.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.settingsPane != null) {
            this.settingsPane.apply();
        }
    }

    public void reset() {
        if (this.settingsPane != null) {
            this.settingsPane.reset();
        }
    }

    public void disposeUIResources() {
        this.settingsPane = null;
    }
}

