/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class PsiIdentifierOwnerTokenizer
extends Tokenizer<PsiNameIdentifierOwner> {
    public static final PsiIdentifierOwnerTokenizer INSTANCE = new PsiIdentifierOwnerTokenizer();

    @Override
    public void tokenize(@NotNull PsiNameIdentifierOwner element, TokenConsumer consumer) {
        PsiElement identifier = element.getNameIdentifier();
        if (identifier == null) {
            return;
        }
        PsiNameIdentifierOwner parent = element;
        TextRange range2 = identifier.getTextRange();
        if (range2.isEmpty()) {
            return;
        }
        int offset = range2.getStartOffset() - parent.getTextRange().getStartOffset();
        if (offset < 0) {
            parent = PsiTreeUtil.findCommonParent((PsiElement)identifier, (PsiElement)element);
            offset = range2.getStartOffset() - parent.getTextRange().getStartOffset();
        }
        String text = identifier.getText();
        consumer.consumeToken((PsiElement)parent, text, true, offset, TextRange.allOf((String)text), IdentifierSplitter.getInstance());
    }
}

