/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.xml;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.xml.NoSpellchecking;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;

public class XmlSpellcheckingStrategy
extends SuppressibleSpellcheckingStrategy {
    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiElement injection;
        PsiFile file2;
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && ((file2 = element.getContainingFile()) == null || file2.getLanguage() instanceof TemplateLanguage)) {
            return EMPTY_TOKENIZER;
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (injection = InjectedLanguageManager.getInstance((Project)element.getProject()).findInjectedElementAt(element.getContainingFile(), element.getTextOffset())) == null) {
            return TEXT_TOKENIZER;
        }
        return super.getTokenizer(element);
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String name) {
        DomElement domElement = DomUtil.getDomElement((PsiElement)element);
        return domElement != null && domElement.getAnnotation(NoSpellchecking.class) != null;
    }

    @Override
    public SuppressQuickFix[] getSuppressActions(@NotNull PsiElement element, @NotNull String name) {
        return SuppressQuickFix.EMPTY_ARRAY;
    }
}

