/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.ProjectTaskState;
import com.intellij.task.impl.AbstractProjectTask;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTaskManagerImpl
extends ProjectTaskManager {
    private final ProjectTaskRunner myDummyTaskRunner = new DummyTaskRunner();
    private final ProjectTaskListener myEventPublisher;

    public ProjectTaskManagerImpl(@NotNull Project project) {
        super(project);
        this.myEventPublisher = (ProjectTaskListener)project.getMessageBus().syncPublisher(ProjectTaskListener.TOPIC);
    }

    public void build(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback2) {
        this.run(this.createModulesBuildTask(modules, true, true, false), callback2);
    }

    public void rebuild(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback2) {
        this.run(this.createModulesBuildTask(modules, false, false, false), callback2);
    }

    public void compile(@NotNull VirtualFile[] files2, @Nullable ProjectTaskNotification callback2) {
        List buildTasks = ContainerUtil.map(Arrays.stream(files2).collect(Collectors.groupingBy(file2 -> ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getModuleForFile(file2, false))).entrySet(), entry -> new ModuleFilesBuildTaskImpl((Module)entry.getKey(), false, (Collection)entry.getValue()));
        this.run(new ProjectTaskList(buildTasks), callback2);
    }

    public void build(@NotNull ProjectModelBuildableElement[] buildableElements, @Nullable ProjectTaskNotification callback2) {
        this.doBuild(buildableElements, callback2, true);
    }

    public void rebuild(@NotNull ProjectModelBuildableElement[] buildableElements, @Nullable ProjectTaskNotification callback2) {
        this.doBuild(buildableElements, callback2, false);
    }

    public void buildAllModules(@Nullable ProjectTaskNotification callback2) {
        this.run(this.createAllModulesBuildTask(true, this.myProject), callback2);
    }

    public void rebuildAllModules(@Nullable ProjectTaskNotification callback2) {
        this.run(this.createAllModulesBuildTask(false, this.myProject), callback2);
    }

    public ProjectTask createAllModulesBuildTask(boolean isIncrementalBuild, Project project) {
        return this.createModulesBuildTask(ModuleManager.getInstance((Project)project).getModules(), isIncrementalBuild, false, false);
    }

    public ProjectTask createModulesBuildTask(Module module, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return this.createModulesBuildTask((Module[])ContainerUtil.ar((Object[])new Module[]{module}), isIncrementalBuild, includeDependentModules, includeRuntimeDependencies);
    }

    public ProjectTask createModulesBuildTask(Module[] modules, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return modules.length == 1 ? new ModuleBuildTaskImpl(modules[0], isIncrementalBuild, includeDependentModules, includeRuntimeDependencies) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])modules), module -> new ModuleBuildTaskImpl((Module)module, isIncrementalBuild, includeDependentModules, includeRuntimeDependencies)));
    }

    public ProjectTask createBuildTask(boolean isIncrementalBuild, ProjectModelBuildableElement ... buildableElements) {
        return buildableElements.length == 1 ? new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>(buildableElements[0], isIncrementalBuild) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])buildableElements), buildableElement -> new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>((ProjectModelBuildableElement)buildableElement, isIncrementalBuild)));
    }

    public void run(@NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification callback2) {
        this.run(new ProjectTaskContext(), projectTask, callback2);
    }

    public void run(@NotNull ProjectTaskContext context, @NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification callback2) {
        SmartList toRun = new SmartList();
        Consumer taskClassifier = arg_0 -> this.lambda$run$6((List)toRun, arg_0);
        ProjectTaskManagerImpl.visitTasks((Collection<? extends ProjectTask>)(projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask)), (Consumer<? super Collection<? extends ProjectTask>>)taskClassifier);
        this.myEventPublisher.started(context);
        if (toRun.isEmpty()) {
            ProjectTaskManagerImpl.sendSuccessNotify(new ListenerNotificator(context, callback2));
            return;
        }
        ProjectTaskResultsAggregator callbacksCollector = new ProjectTaskResultsAggregator(new ListenerNotificator(context, callback2), toRun.size());
        for (Pair pair : toRun) {
            callback2 = new ProjectTaskRunnerNotification((Collection)pair.second, callbacksCollector);
            if (((Collection)pair.second).isEmpty()) {
                ProjectTaskManagerImpl.sendSuccessNotify(callback2);
                continue;
            }
            ((ProjectTaskRunner)pair.first).run(this.myProject, context, callback2, (Collection)pair.second);
        }
    }

    private static void sendSuccessNotify(@Nullable ProjectTaskNotification notification) {
        if (notification != null) {
            notification.finished(new ProjectTaskResult(false, 0, 0));
        }
    }

    private static void visitTasks(@NotNull Collection<? extends ProjectTask> tasks, @NotNull Consumer<? super Collection<? extends ProjectTask>> consumer) {
        for (ProjectTask projectTask : tasks) {
            Collection<ProjectTask> taskDependencies = projectTask instanceof AbstractProjectTask ? ((AbstractProjectTask)projectTask).getDependsOn() : (projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask));
            ProjectTaskManagerImpl.visitTasks(taskDependencies, consumer);
        }
        consumer.consume(tasks);
    }

    @NotNull
    private static ProjectTaskRunner[] getTaskRunners() {
        return (ProjectTaskRunner[])ProjectTaskRunner.EP_NAME.getExtensions();
    }

    private void doBuild(@NotNull ProjectModelBuildableElement[] buildableElements, @Nullable ProjectTaskNotification callback2, boolean isIncrementalBuild) {
        this.run(this.createBuildTask(isIncrementalBuild, buildableElements), callback2);
    }

    private /* synthetic */ void lambda$run$6(List toRun, Collection tasks) {
        Map<ProjectTaskRunner, List<ProjectTask>> toBuild = tasks.stream().collect(Collectors.groupingBy(aTask -> Arrays.stream(ProjectTaskManagerImpl.getTaskRunners()).filter(runner -> runner.canRun(this.myProject, aTask)).findFirst().orElse(this.myDummyTaskRunner)));
        for (Map.Entry<ProjectTaskRunner, List<ProjectTask>> entry : toBuild.entrySet()) {
            toRun.add(Pair.create((Object)entry.getKey(), entry.getValue()));
        }
    }

    private static class ProjectTaskResultsAggregator {
        private final ProjectTaskNotification myDelegate;
        private final AtomicInteger myProgressCounter;
        private final AtomicInteger myErrorsCounter;
        private final AtomicInteger myWarningsCounter;
        private final AtomicBoolean myAbortedFlag;
        private final Map<ProjectTask, ProjectTaskState> myTasksState = ContainerUtil.newConcurrentMap();

        private ProjectTaskResultsAggregator(@NotNull ProjectTaskNotification delegate, int expectedResults) {
            this.myDelegate = delegate;
            this.myProgressCounter = new AtomicInteger(expectedResults);
            this.myErrorsCounter = new AtomicInteger();
            this.myWarningsCounter = new AtomicInteger();
            this.myAbortedFlag = new AtomicBoolean(false);
        }

        public void add(@NotNull ProjectTaskResult executionResult) {
            int inProgress = this.myProgressCounter.decrementAndGet();
            int allErrors = this.myErrorsCounter.addAndGet(executionResult.getErrors());
            int allWarnings = this.myWarningsCounter.addAndGet(executionResult.getWarnings());
            this.myTasksState.putAll(executionResult.getTasksState());
            if (executionResult.isAborted()) {
                this.myAbortedFlag.set(true);
            }
            if (inProgress <= 0) {
                ProjectTaskResult result2 = new ProjectTaskResult(this.myAbortedFlag.get(), allErrors, allWarnings, this.myTasksState);
                this.myDelegate.finished(result2);
            }
        }
    }

    private static class ProjectTaskRunnerNotification
    implements ProjectTaskNotification {
        private final ProjectTaskResultsAggregator myAggregator;
        private final Collection<? extends ProjectTask> myTasks;

        private ProjectTaskRunnerNotification(@NotNull Collection<? extends ProjectTask> tasks, @NotNull ProjectTaskResultsAggregator aggregator) {
            this.myTasks = tasks;
            this.myAggregator = aggregator;
        }

        public void finished(@NotNull ProjectTaskResult result2) {
            if (result2.getTasksState().isEmpty()) {
                final boolean aborted = result2.isAborted();
                final int errors = result2.getErrors();
                ProjectTaskState state = new ProjectTaskState(){

                    public boolean isSkipped() {
                        return aborted;
                    }

                    public boolean isFailed() {
                        return errors > 0;
                    }
                };
                Map tasksState = StreamEx.of(this.myTasks).toMap(Function.identity(), task2 -> state);
                result2 = new ProjectTaskResult(aborted, errors, result2.getWarnings(), tasksState);
            }
            this.myAggregator.add(result2);
        }
    }

    private class ListenerNotificator
    implements ProjectTaskNotification {
        @Nullable
        private final ProjectTaskNotification myDelegate;
        @NotNull
        private final ProjectTaskContext myContext;

        private ListenerNotificator(@Nullable ProjectTaskContext context, ProjectTaskNotification delegate) {
            this.myContext = context;
            this.myDelegate = delegate;
        }

        public void finished(@NotNull ProjectTaskResult executionResult) {
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (!ProjectTaskManagerImpl.this.myProject.isDisposed()) {
                    ProjectTaskManagerImpl.this.myEventPublisher.finished(this.myContext, executionResult);
                }
                if (this.myDelegate != null) {
                    this.myDelegate.finished(executionResult);
                }
            }, (ModalityState)ModalityState.defaultModalityState());
        }
    }

    private static class DummyTaskRunner
    extends ProjectTaskRunner {
        private DummyTaskRunner() {
        }

        public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback2, @NotNull Collection<? extends ProjectTask> tasks) {
            ProjectTaskManagerImpl.sendSuccessNotify(callback2);
        }

        public boolean canRun(@NotNull ProjectTask projectTask) {
            return true;
        }
    }
}

