/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vcs.BranchChangeListener;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.context.ConfigureBranchContextDialog;
import com.intellij.tasks.context.WorkingContextManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BranchContextTracker
implements BranchChangeListener {
    public static final NotificationGroup NOTIFICATION = new NotificationGroup("Branch Context group", NotificationDisplayType.BALLOON, true);
    private final WorkingContextManager myContextManager;
    private final Project myProject;
    private String myLastBranch;

    private BranchContextTracker(Project project) {
        this.myProject = project;
        this.myContextManager = WorkingContextManager.getInstance(project);
        project.getMessageBus().connect().subscribe(BranchChangeListener.VCS_BRANCH_CHANGED, (Object)this);
    }

    public void branchWillChange(@NotNull String branchName) {
        this.myLastBranch = branchName;
        this.myContextManager.saveContext(BranchContextTracker.getContextName(branchName), null);
    }

    public void branchHasChanged(@NotNull String branchName) {
        LocalTask task2;
        List branches;
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (!vcsConfiguration.RELOAD_CONTEXT) {
            return;
        }
        TaskManager manager = TaskManager.getManager((Project)this.myProject);
        if (manager != null && (branches = (task2 = manager.getActiveTask()).getBranches(false)).stream().anyMatch(info -> branchName.equals(info.name))) {
            return;
        }
        String contextName = BranchContextTracker.getContextName(branchName);
        if (!this.myContextManager.hasContext(contextName)) {
            return;
        }
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> this.switchContext(branchName, contextName));
    }

    private void switchContext(@NotNull String branchName, String contextName) {
        this.myContextManager.clearContext();
        this.myContextManager.loadContext(contextName);
        Notification notification = NOTIFICATION.createNotification("Workspace associated with branch '" + branchName + "' has been restored", NotificationType.INFORMATION);
        if (this.myLastBranch != null && this.myContextManager.hasContext(BranchContextTracker.getContextName(this.myLastBranch))) {
            notification.addAction((AnAction)new NotificationAction("Rollback"){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    BranchContextTracker.this.myContextManager.clearContext();
                    BranchContextTracker.this.myContextManager.loadContext(BranchContextTracker.getContextName(BranchContextTracker.this.myLastBranch));
                }
            });
        }
        notification.addAction((AnAction)new NotificationAction("Configure..."){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                new ConfigureBranchContextDialog(BranchContextTracker.this.myProject).show();
            }
        }).setContextHelpAction(new AnAction("What is a workspace?", "A workspace is a set of opened files, the current run configuration, and breakpoints.", null){

            public void actionPerformed(@NotNull AnActionEvent e) {
            }
        }).notify(this.myProject);
    }

    @NotNull
    private static String getContextName(String branchName) {
        return "__branch_context_" + branchName;
    }

    public static class TrackerStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            new BranchContextTracker(project);
        }
    }
}

