/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.BreakpointManagerState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class XDebuggerBreakpointsContextProvider
extends WorkingContextProvider {
    private final XBreakpointManagerImpl myBreakpointManager;

    public XDebuggerBreakpointsContextProvider(XDebuggerManager xDebuggerManager) {
        this.myBreakpointManager = (XBreakpointManagerImpl)xDebuggerManager.getBreakpointManager();
    }

    @NotNull
    public String getId() {
        return "xDebugger";
    }

    @NotNull
    public String getDescription() {
        return "XDebugger breakpoints";
    }

    public void saveContext(Element toElement) throws WriteExternalException {
        BreakpointManagerState state = new BreakpointManagerState();
        this.myBreakpointManager.saveState(state);
        Element serialize = XmlSerializer.serialize((Object)((Object)state));
        if (serialize != null) {
            toElement.addContent((Collection)serialize.removeContent());
        }
    }

    public void loadContext(Element fromElement) throws InvalidDataException {
        this.myBreakpointManager.loadState((BreakpointManagerState)((Object)XmlSerializer.deserialize((Element)fromElement, BreakpointManagerState.class)));
    }

    public void clearContext() {
        XBreakpointBase<?, ?, ?>[] breakpoints;
        for (XBreakpointBase<?, ?, ?> breakpoint : breakpoints = this.myBreakpointManager.getAllBreakpoints()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.myBreakpointManager.removeBreakpoint(breakpoint));
        }
    }
}

