/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.WatchesManagerState;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class XDebuggerWatchesProvider
extends WorkingContextProvider {
    private final XDebuggerWatchesManager myWatchesManager;

    public XDebuggerWatchesProvider(XDebuggerManager xDebuggerManager) {
        this.myWatchesManager = ((XDebuggerManagerImpl)xDebuggerManager).getWatchesManager();
    }

    @NotNull
    public String getId() {
        return "watches";
    }

    @NotNull
    public String getDescription() {
        return "Debugger watches";
    }

    public void saveContext(Element toElement) throws WriteExternalException {
        WatchesManagerState state = new WatchesManagerState();
        this.myWatchesManager.saveState(state);
        Element serialize = XmlSerializer.serialize((Object)((Object)state));
        if (serialize != null) {
            toElement.addContent((Collection)serialize.removeContent());
        }
    }

    public void loadContext(Element fromElement) throws InvalidDataException {
        WatchesManagerState state = (WatchesManagerState)((Object)XmlSerializer.deserialize((Element)fromElement, WatchesManagerState.class));
        this.myWatchesManager.loadState(state);
    }

    public void clearContext() {
        this.myWatchesManager.clearContext();
    }
}

