/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.BranchInfo;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.Comment;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.timeTracking.model.WorkItem;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import icons.TasksIcons;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="task")
public class LocalTaskImpl
extends LocalTask {
    @NonNls
    public static final String DEFAULT_TASK_ID = "Default";
    private String myId = "";
    private String mySummary = "";
    private String myDescription = null;
    private Comment[] myComments = Comment.EMPTY_ARRAY;
    private boolean myClosed = false;
    private Date myCreated;
    private Date myUpdated;
    private TaskType myType = TaskType.OTHER;
    private String myPresentableName;
    private String myCustomIcon = null;
    private String myProject = null;
    private String myNumber = "";
    private String myPresentableId = "";
    private boolean myIssue = false;
    private TaskRepository myRepository = null;
    private String myIssueUrl = null;
    private boolean myActive;
    private List<ChangeListInfo> myChangeLists = new ArrayList<ChangeListInfo>();
    private String myShelfName;
    private boolean myRunning = false;
    private List<WorkItem> myWorkItems = new ArrayList<WorkItem>();
    private Date myLastPost;
    private List<BranchInfo> myBranches = new ArrayList<BranchInfo>();

    public LocalTaskImpl() {
    }

    public LocalTaskImpl(@NotNull String id, @NotNull String summary) {
        this.myId = id;
        this.mySummary = summary;
    }

    public LocalTaskImpl(Task origin) {
        this.myId = origin.getId();
        this.myIssue = origin.isIssue();
        this.myRepository = origin.getRepository();
        this.copy(origin);
        if (origin instanceof LocalTaskImpl) {
            this.myChangeLists = ((LocalTaskImpl)origin).getChangeLists();
            this.myBranches = ((LocalTaskImpl)origin).getBranches();
            this.myActive = ((LocalTaskImpl)origin).isActive();
            this.myWorkItems = ((LocalTaskImpl)origin).getWorkItems();
            this.myRunning = ((LocalTaskImpl)origin).isRunning();
            this.myLastPost = ((LocalTaskImpl)origin).getLastPost();
            this.myPresentableName = ((LocalTaskImpl)origin).myPresentableName;
        }
    }

    @Attribute(value="id")
    @NotNull
    public String getId() {
        return this.myId;
    }

    @Attribute(value="summary")
    @NotNull
    public String getSummary() {
        return this.mySummary;
    }

    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public Comment[] getComments() {
        return this.myComments;
    }

    @Tag(value="updated")
    public Date getUpdated() {
        return this.myUpdated == null ? this.getCreated() : this.myUpdated;
    }

    @Tag(value="created")
    public Date getCreated() {
        if (this.myCreated == null) {
            this.myCreated = new Date();
        }
        return this.myCreated;
    }

    @Attribute(value="active")
    public boolean isActive() {
        return this.myActive;
    }

    public void updateFromIssue(Task issue) {
        this.copy(issue);
        this.myIssue = true;
    }

    private void copy(Task issue) {
        this.mySummary = issue.getSummary();
        this.myDescription = issue.getDescription();
        this.myComments = issue.getComments();
        this.myClosed = issue.isClosed();
        this.myCreated = issue.getCreated();
        if (Comparing.compare((Comparable)this.myUpdated, (Comparable)issue.getUpdated()) < 0) {
            this.myUpdated = issue.getUpdated();
        }
        this.myType = issue.getType();
        this.myPresentableName = issue.getPresentableName();
        this.myCustomIcon = issue.getCustomIcon();
        this.myIssueUrl = issue.getIssueUrl();
        this.myRepository = issue.getRepository();
        this.myProject = issue.getProject();
        this.myNumber = issue.getNumber();
        this.myPresentableId = issue.getPresentableId();
    }

    public void setId(String id) {
        this.myId = id;
    }

    public void setSummary(String summary) {
        this.mySummary = summary;
    }

    public void setActive(boolean active) {
        this.myActive = active;
    }

    public boolean isIssue() {
        return this.myIssue;
    }

    @Tag(value="url")
    public String getIssueUrl() {
        return this.myIssueUrl;
    }

    public String setIssueUrl(String url) {
        this.myIssueUrl = url;
        return this.myIssueUrl;
    }

    public void setIssue(boolean issue) {
        this.myIssue = issue;
    }

    @Transient
    public TaskRepository getRepository() {
        return this.myRepository;
    }

    public void setRepository(TaskRepository repository) {
        this.myRepository = repository;
    }

    public void setCreated(Date created) {
        this.myCreated = created;
    }

    public void setUpdated(Date updated) {
        this.myUpdated = updated;
    }

    @Property(surroundWithTag=false)
    @XCollection(elementName="changelist")
    @NotNull
    public List<ChangeListInfo> getChangeLists() {
        return this.myChangeLists;
    }

    public void setChangeLists(List<ChangeListInfo> changeLists) {
        this.myChangeLists = changeLists;
    }

    public void addChangelist(ChangeListInfo info) {
        if (!this.myChangeLists.contains(info)) {
            this.myChangeLists.add(info);
        }
    }

    public void removeChangelist(ChangeListInfo info) {
        this.myChangeLists.remove(info);
    }

    @Property(surroundWithTag=false)
    @XCollection(elementName="branch")
    @NotNull
    public List<BranchInfo> getBranches() {
        return this.myBranches;
    }

    public void setBranches(List<BranchInfo> branches) {
        this.myBranches = branches;
    }

    public void addBranch(BranchInfo info) {
        this.myBranches.add(info);
    }

    public void removeBranch(BranchInfo info) {
        this.myBranches.add(info);
    }

    public String getShelfName() {
        return this.myShelfName;
    }

    public void setShelfName(String shelfName) {
        this.myShelfName = shelfName;
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    public void setClosed(boolean closed) {
        this.myClosed = closed;
    }

    @NotNull
    public Icon getIcon() {
        String customIcon = this.getCustomIcon();
        if (customIcon != null && this.myRepository != null) {
            return IconLoader.getIcon((String)customIcon, this.myRepository.getClass());
        }
        return LocalTaskImpl.getIconFromType(this.myType, this.isIssue());
    }

    public static Icon getIconFromType(TaskType type, boolean issue) {
        switch (type) {
            case BUG: {
                return TasksIcons.Bug;
            }
            case EXCEPTION: {
                return TasksIcons.Exception;
            }
            case FEATURE: {
                return TasksIcons.Feature;
            }
        }
        return issue ? TasksIcons.Other : TasksIcons.Unknown;
    }

    @NotNull
    public TaskType getType() {
        return this.myType;
    }

    public void setType(TaskType type) {
        this.myType = type == null ? TaskType.OTHER : type;
    }

    public boolean isDefault() {
        return this.myId.equals(DEFAULT_TASK_ID);
    }

    public String getPresentableName() {
        return this.myPresentableName != null ? this.myPresentableName : this.toString();
    }

    public String getCustomIcon() {
        return this.myCustomIcon;
    }

    public long getTotalTimeSpent() {
        long timeSpent = 0L;
        for (WorkItem item : this.myWorkItems) {
            timeSpent += item.duration;
        }
        return timeSpent;
    }

    @Tag(value="running")
    public boolean isRunning() {
        return this.myRunning;
    }

    public void setRunning(boolean running) {
        this.myRunning = running;
    }

    public void setWorkItems(List<WorkItem> workItems) {
        this.myWorkItems = workItems;
    }

    @Property(surroundWithTag=false)
    @XCollection(elementName="workItem")
    @NotNull
    public List<WorkItem> getWorkItems() {
        return this.myWorkItems;
    }

    public void addWorkItem(WorkItem workItem) {
        this.myWorkItems.add(workItem);
    }

    @Tag(value="lastPost")
    public Date getLastPost() {
        return this.myLastPost;
    }

    public void setLastPost(Date date) {
        this.myLastPost = date;
    }

    public long getTimeSpentFromLastPost() {
        long timeSpent = 0L;
        if (this.myLastPost != null) {
            for (WorkItem item : this.myWorkItems) {
                if (item.from.getTime() < this.myLastPost.getTime()) {
                    if (item.from.getTime() + item.duration <= this.myLastPost.getTime()) continue;
                    timeSpent += item.from.getTime() + item.duration - this.myLastPost.getTime();
                    continue;
                }
                timeSpent += item.duration;
            }
        } else {
            for (WorkItem item : this.myWorkItems) {
                timeSpent += item.duration;
            }
        }
        return timeSpent;
    }

    @NotNull
    public String getNumber() {
        return StringUtil.isEmpty((String)this.myNumber) ? LocalTaskImpl.extractNumberFromId((String)this.myId) : this.myNumber;
    }

    public void setNumber(@NotNull String number) {
        this.myNumber = number;
    }

    @Nullable
    public String getProject() {
        return StringUtil.isEmpty((String)this.myProject) ? LocalTaskImpl.extractProjectFromId((String)this.myId) : this.myProject;
    }

    public void setProject(@Nullable String project) {
        this.myProject = project;
    }

    public void setPresentableId(@NotNull String presentableId) {
        this.myPresentableId = presentableId;
    }

    @NotNull
    public String getPresentableId() {
        return StringUtil.isEmpty((String)this.myPresentableId) ? this.getId() : this.myPresentableId;
    }
}

