/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.jediterm.terminal.Questioner;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class ProcessHandlerTtyConnector
implements TtyConnector {
    private final OSProcessHandler myProcessHandler;
    private final PtyProcess myPtyProcess;
    protected Charset myCharset;

    public ProcessHandlerTtyConnector(@NotNull ProcessHandler processHandler2, @NotNull Charset charset) {
        if (!(processHandler2 instanceof OSProcessHandler)) {
            throw new IllegalArgumentException("Works currently only with OSProcessHandler");
        }
        this.myProcessHandler = (OSProcessHandler)processHandler2;
        if (!(this.myProcessHandler.getProcess() instanceof PtyProcess)) {
            throw new IllegalArgumentException("Should be a PTY based process");
        }
        this.myPtyProcess = (PtyProcess)this.myProcessHandler.getProcess();
        this.myCharset = charset;
    }

    public boolean init(Questioner q) {
        return true;
    }

    public void close() {
        this.myProcessHandler.destroyProcess();
    }

    public void resize(Dimension termSize, Dimension pixelSize) {
        if (termSize != null && pixelSize != null && this.myPtyProcess.isRunning()) {
            this.myPtyProcess.setWinSize(new WinSize(termSize.width, termSize.height, pixelSize.width, pixelSize.height));
        }
    }

    public String getName() {
        return "TtyConnector:" + this.myProcessHandler.toString();
    }

    public int read(char[] buf, int offset, int length) throws IOException {
        throw new IllegalStateException("all reads should be performed by ProcessHandler");
    }

    public void write(byte[] bytes) throws IOException {
        this.myProcessHandler.getProcessInput().write(bytes);
        this.myProcessHandler.getProcessInput().flush();
    }

    public boolean isConnected() {
        return false;
    }

    public void write(String string) throws IOException {
        this.myProcessHandler.getProcessInput().write(string.getBytes(this.myCharset));
        this.myProcessHandler.getProcessInput().flush();
    }

    public int waitFor() throws InterruptedException {
        return this.myPtyProcess.waitFor();
    }
}

