/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.terminal.AppendableTerminalDataStream;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.PendingTasksRunner;
import com.intellij.terminal.ProcessHandlerTtyConnector;
import com.intellij.terminal.TerminalConsoleContentHelper;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalKeyEncoder;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalSession;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.pty4j.PtyProcess;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalExecutionConsole
implements ConsoleView,
ObservableConsoleView {
    private static final Logger LOG = Logger.getInstance(TerminalExecutionConsole.class);
    private JBTerminalWidget myTerminalWidget;
    private final Project myProject;
    private final AppendableTerminalDataStream myDataStream;
    private final AtomicBoolean myAttachedToProcess = new AtomicBoolean(false);
    private volatile boolean myLastCR = false;
    private final PendingTasksRunner myOnResizedRunner;
    private final TerminalConsoleContentHelper myContentHelper = new TerminalConsoleContentHelper(this);
    private boolean myEnableConsoleActions = true;
    private boolean myEnterKeyDefaultCodeEnabled = false;
    private final TerminalKeyEncoder myKeyEncoder = new TerminalKeyEncoder();

    public TerminalExecutionConsole(@NotNull Project project, @Nullable ProcessHandler processHandler2) {
        this.myKeyEncoder.setAutoNewLine(true);
        this.myProject = project;
        this.myOnResizedRunner = new PendingTasksRunner(2000L, project);
        JBTerminalSystemSettingsProviderBase provider = new JBTerminalSystemSettingsProviderBase(){

            public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode() {
                return HyperlinkStyle.HighlightMode.ALWAYS;
            }
        };
        this.myDataStream = new AppendableTerminalDataStream();
        this.myTerminalWidget = new ConsoleTerminalWidget(project, provider);
        Disposer.register((Disposable)this.myTerminalWidget, (Disposable)provider);
        if (processHandler2 != null) {
            this.attachToProcess(processHandler2);
        }
    }

    private void printText(@NotNull String text, @Nullable ConsoleViewContentType contentType) throws IOException {
        if (contentType != null) {
            this.myDataStream.append(TerminalExecutionConsole.encodeColor(contentType.getAttributes().getForegroundColor()));
        }
        this.myDataStream.append(text);
        if (contentType != null) {
            this.myDataStream.append("\u001b[39m");
        }
        this.myContentHelper.onContentTypePrinted((ConsoleViewContentType)ObjectUtils.notNull((Object)contentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT));
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        this.myContentHelper.addChangeListener(listener2, parent);
    }

    private static String encodeColor(Color color) {
        return "\u001b[38;2;" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + "m";
    }

    public void setAutoNewLineMode(boolean enabled) {
        this.myKeyEncoder.setAutoNewLine(enabled);
    }

    @Deprecated
    @NotNull
    public TerminalExecutionConsole withEnterKeyLineSeparator(@NotNull LineSeparator lineSeparator) {
        return this;
    }

    @NotNull
    public TerminalExecutionConsole withEnterKeyDefaultCodeEnabled(boolean enterKeyDefaultCodeEnabled) {
        this.myEnterKeyDefaultCodeEnabled = enterKeyDefaultCodeEnabled;
        return this;
    }

    public void addMessageFilter(Project project, Filter filter) {
        this.myTerminalWidget.addMessageFilter(project, filter);
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        String textCRLF = this.convertTextToCRLF(text);
        try {
            this.printText(textCRLF, contentType);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private String convertTextToCRLF(@NotNull String text) {
        boolean preserveLastCR;
        if (text.isEmpty()) {
            return text;
        }
        boolean preserveFirstLF = text.startsWith(LineSeparator.LF.getSeparatorString()) && this.myLastCR;
        this.myLastCR = preserveLastCR = text.endsWith(LineSeparator.CR.getSeparatorString());
        String textToConvert = text.substring(preserveFirstLF ? 1 : 0, preserveLastCR ? text.length() - 1 : text.length());
        String textCRLF = StringUtil.convertLineSeparators((String)textToConvert, (String)LineSeparator.CRLF.getSeparatorString());
        if (preserveFirstLF) {
            textCRLF = LineSeparator.LF.getSeparatorString() + textCRLF;
        }
        if (preserveLastCR) {
            textCRLF = textCRLF + LineSeparator.CR.getSeparatorString();
        }
        return textCRLF;
    }

    public void clear() {
        this.myLastCR = false;
        this.myTerminalWidget.getTerminalPanel().clearBuffer();
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        if (processHandler2 != null) {
            this.attachToProcess(processHandler2, true);
        }
    }

    protected final void attachToProcess(@NotNull ProcessHandler processHandler2, boolean attachToProcessOutput) {
        if (!this.myAttachedToProcess.compareAndSet(false, true)) {
            return;
        }
        JediTermWidget session2 = this.myTerminalWidget.createTerminalSession(new ProcessHandlerTtyConnector(processHandler2, EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset()));
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter((TerminalSession)session2, attachToProcessOutput){
            final /* synthetic */ TerminalSession val$session;
            final /* synthetic */ boolean val$attachToProcessOutput;
            {
                this.val$session = terminalSession;
                this.val$attachToProcessOutput = bl;
            }

            public void startNotified(@NotNull ProcessEvent event) {
                this.val$session.start();
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (this.val$attachToProcessOutput) {
                    TerminalExecutionConsole.this.myOnResizedRunner.execute(() -> {
                        try {
                            ConsoleViewContentType contentType = null;
                            if (outputType != ProcessOutputTypes.STDOUT) {
                                contentType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                            }
                            String text = event.getText();
                            if (outputType == ProcessOutputTypes.SYSTEM) {
                                text = StringUtil.convertLineSeparators((String)text, (String)LineSeparator.CRLF.getSeparatorString());
                            }
                            TerminalExecutionConsole.this.printText(text, contentType);
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                        }
                    });
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    JBTerminalWidget widget = TerminalExecutionConsole.this.myTerminalWidget;
                    if (widget != null) {
                        widget.getTerminalPanel().setCursorVisible(false);
                    }
                }, ModalityState.any());
            }
        });
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
    }

    public void setHelpId(@NotNull String helpId) {
    }

    public void addMessageFilter(@NotNull Filter filter) {
        this.addMessageFilter(this.myProject, filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    public void enableConsoleActions(boolean enableConsoleActions) {
        this.myEnableConsoleActions = enableConsoleActions;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (this.myEnableConsoleActions) {
            return new AnAction[]{new ScrollToTheEndAction(), new ClearAction()};
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public void dispose() {
        this.myTerminalWidget = null;
    }

    public static boolean isAcceptable(@NotNull ProcessHandler processHandler2) {
        return processHandler2 instanceof OSProcessHandler && ((OSProcessHandler)processHandler2).getProcess() instanceof PtyProcess && !(processHandler2 instanceof ColoredProcessHandler);
    }

    private class ScrollToTheEndAction
    extends DumbAwareAction {
        private ScrollToTheEndAction() {
            super(ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), AllIcons.RunConfigurations.Scroll_down);
        }

        public void update(@NotNull AnActionEvent e) {
            BoundedRangeModel model = TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().getBoundedRangeModel();
            e.getPresentation().setEnabled(model.getValue() != 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BoundedRangeModel model = TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().getBoundedRangeModel();
            model.setValue(0);
        }
    }

    private class ClearAction
    extends DumbAwareAction {
        private ClearAction() {
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]), "Clear the contents of the console", AllIcons.Actions.GC);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TerminalExecutionConsole.this.clear();
        }
    }

    private class ConsoleTerminalWidget
    extends JBTerminalWidget
    implements DataProvider {
        private ConsoleTerminalWidget(@NotNull Project project, JBTerminalSystemSettingsProviderBase provider) {
            super(project, 200, 24, provider, (Disposable)TerminalExecutionConsole.this);
        }

        @Override
        protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
            JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState){

                public Dimension requestResize(Dimension newSize, RequestOrigin origin, int cursorY, JediTerminal.ResizeHandler resizeHandler) {
                    Dimension dimension = super.requestResize(newSize, origin, cursorY, resizeHandler);
                    TerminalExecutionConsole.this.myOnResizedRunner.setReady();
                    return dimension;
                }

                public void clearBuffer() {
                    super.clearBuffer(false);
                }
            };
            Disposer.register((Disposable)this, (Disposable)panel2);
            return panel2;
        }

        @Override
        protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
            return new TerminalStarter((Terminal)terminal, connector, TerminalExecutionConsole.this.myDataStream){

                public byte[] getCode(int key, int modifiers) {
                    if (key == 10) {
                        if (modifiers == 0 && TerminalExecutionConsole.this.myEnterKeyDefaultCodeEnabled) {
                            return SystemInfo.isWindows ? LineSeparator.CR.getSeparatorBytes() : LineSeparator.LF.getSeparatorBytes();
                        }
                        return TerminalExecutionConsole.this.myKeyEncoder.getCode(key, modifiers);
                    }
                    return super.getCode(key, modifiers);
                }
            };
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
                return TerminalExecutionConsole.this;
            }
            return null;
        }
    }
}

