/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testIntegration.GotoTestOrCodeHandler;
import com.intellij.testIntegration.TestFinderHelper;
import org.jetbrains.annotations.NotNull;

public class GotoTestOrCodeAction
extends BaseCodeInsightAction {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new GotoTestOrCodeHandler();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(false);
        if (TestFinderHelper.getFinders().size() == 0) {
            return;
        }
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null || project == null) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null) {
            return;
        }
        PsiElement element = GotoTestOrCodeHandler.getSelectedElement(editor, psiFile);
        if (TestFinderHelper.findSourceElement(element) == null) {
            return;
        }
        presentation.setEnabledAndVisible(true);
        if (TestFinderHelper.isTest(element)) {
            presentation.setText(ActionsBundle.message((String)"action.GotoTestSubject.text", (Object[])new Object[0]));
            presentation.setDescription(ActionsBundle.message((String)"action.GotoTestSubject.description", (Object[])new Object[0]));
        } else {
            presentation.setText(ActionsBundle.message((String)"action.GotoTest.text", (Object[])new Object[0]));
            presentation.setDescription(ActionsBundle.message((String)"action.GotoTest.description", (Object[])new Object[0]));
        }
    }
}

