/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.BaseToolManager;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolSelectDialog;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolSelectComboBox<T extends Tool>
extends ComboboxWithBrowseButton {
    public static final Object NONE_TOOL = ObjectUtils.sentinel((String)"NONE_TOOL");

    public BaseToolSelectComboBox() {
        final JComboBox comboBox2 = this.getComboBox();
        comboBox2.setModel(new CollectionComboBoxModel(this.getComboBoxElements(), null){

            public void setSelectedItem(@Nullable Object item) {
                if (item instanceof ToolsGroup) {
                    return;
                }
                super.setSelectedItem(item);
            }
        });
        comboBox2.setRenderer(new ColoredListCellRenderer<Object>(){

            public Component getListCellRendererComponent(JList<?> list2, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ToolsGroup) {
                    SeparatorWithText separator = new SeparatorWithText();
                    separator.setCaption(StringUtil.notNullize((String)((ToolsGroup)value).getName(), (String)ToolsBundle.message("tools.unnamed.group", new Object[0])));
                    separator.setCaptionCentered(false);
                    return separator;
                }
                return super.getListCellRendererComponent(list2, value, index, selected, hasFocus);
            }

            protected void customizeCellRenderer(@NotNull JList<?> list2, Object value, int index, boolean selected, boolean hasFocus) {
                if (!(value instanceof ToolsGroup)) {
                    if (value instanceof Tool) {
                        this.append(StringUtil.notNullize((String)((Tool)value).getName()), ((Tool)value).isEnabled() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else {
                        this.append(ToolsBundle.message("tools.list.item.none", new Object[0]));
                    }
                }
            }
        });
        this.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolSelectDialog dialog2;
                Object item = comboBox2.getSelectedItem();
                String id = null;
                if (item instanceof Tool) {
                    id = ((Tool)item).getActionId();
                }
                if (!(dialog2 = BaseToolSelectComboBox.this.getToolSelectDialog(id)).showAndGet()) {
                    return;
                }
                comboBox2.setModel(new CollectionComboBoxModel(BaseToolSelectComboBox.this.getComboBoxElements(), (Object)dialog2.getSelectedTool()));
            }
        });
    }

    @NotNull
    protected abstract BaseToolManager<T> getToolManager();

    @NotNull
    protected abstract ToolSelectDialog getToolSelectDialog(@Nullable String var1);

    @NotNull
    protected List<Object> getComboBoxElements() {
        SmartList result2 = new SmartList();
        BaseToolManager<T> manager = this.getToolManager();
        result2.add(NONE_TOOL);
        for (ToolsGroup<T> group : manager.getGroups()) {
            result2.add(group);
            result2.addAll(manager.getTools(group.getName()));
        }
        return result2;
    }

    public int getValuableItemCount() {
        JComboBox comboBox2 = this.getComboBox();
        int itemCount = comboBox2.getItemCount();
        if (itemCount == 0) {
            return 0;
        }
        int valuableCount = 0;
        for (int i = 0; i < itemCount; ++i) {
            if (comboBox2.getItemAt(i) == NONE_TOOL) continue;
            ++valuableCount;
        }
        return valuableCount;
    }

    @Nullable
    public Tool selectTool(@Nullable String toolId) {
        JComboBox comboBox2 = this.getComboBox();
        if (toolId == null) {
            comboBox2.setSelectedIndex(-1);
            return null;
        }
        for (int i = 0; i < comboBox2.getItemCount(); ++i) {
            Object itemAt = comboBox2.getItemAt(i);
            if (!(itemAt instanceof Tool) || !toolId.equals(((Tool)itemAt).getActionId())) continue;
            comboBox2.setSelectedIndex(i);
            return (Tool)itemAt;
        }
        return null;
    }

    @Nullable
    public Tool getSelectedTool() {
        Object item = this.getComboBox().getSelectedItem();
        return item instanceof Tool ? (Tool)item : null;
    }
}

