/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolSelectComboBox;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsProjectConfig;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ExternalToolsCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        final ToolsProjectConfig config2 = ToolsProjectConfig.getInstance(panel2.getProject());
        return new CheckinHandler(){

            public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
                JLabel label2 = new JLabel(ToolsBundle.message("tools.after.commit.description", new Object[0]));
                final ToolSelectComboBox toolComboBox = new ToolSelectComboBox(panel2.getProject());
                BorderLayout layout = new BorderLayout();
                layout.setVgap(3);
                final JPanel panel22 = new JPanel(layout);
                panel22.add((Component)label2, "North");
                panel22.add((Component)((Object)toolComboBox), "Center");
                toolComboBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                if (toolComboBox.getValuableItemCount() == 0) {
                    return null;
                }
                return new RefreshableOnComponent(){

                    public JComponent getComponent() {
                        return panel22;
                    }

                    public void refresh() {
                        String id = config2.getAfterCommitToolsId();
                        toolComboBox.selectTool(id);
                    }

                    public void saveState() {
                        Tool tool = toolComboBox.getSelectedTool();
                        config2.setAfterCommitToolId(tool != null ? tool.getActionId() : null);
                    }

                    public void restoreState() {
                        this.refresh();
                    }
                };
            }

            public void checkinSuccessful() {
                String id = config2.getAfterCommitToolsId();
                if (id == null) {
                    return;
                }
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> UIUtil.invokeAndWaitIfNeeded(() -> ToolAction.runTool(id, context)));
            }
        };
    }
}

