/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonLayoutConfiguration {
    public final int iconPanelWidth;
    public final Dimension iconOffset;
    public final int topSpaceHeight;
    public final int titleContentSpaceHeight;
    public final int contentActionsSpaceHeight;
    public final int titleActionsSpaceHeight;
    public final int bottomSpaceHeight;
    public final int actionGap;
    public final Dimension rightActionsOffset;
    public final int closeOffset;
    public final int gearCloseSpace;
    public final int allActionsOffset;
    public final int beforeGearSpace;
    private static final int RawWidth;
    private static final int RawStyleWidth;

    public static int MaxFullContentWidth() {
        return JBUI.scale((int)350);
    }

    @NotNull
    public static String MaxFullContentWidthStyle() {
        return "width:" + BalloonLayoutConfiguration.MaxFullContentWidth() + "px;";
    }

    public static int MinWidth() {
        return JBUI.scale((int)100);
    }

    public static int FixedWidth() {
        return JBUI.scale((int)RawWidth);
    }

    public static int MaxWidth() {
        return JBUI.scale((int)(RawWidth - 60));
    }

    public static String MaxWidthStyle() {
        return "width:" + JBUI.scale((int)RawStyleWidth) + "px;";
    }

    @NotNull
    public static BalloonLayoutConfiguration create(@NotNull Notification notification, @NotNull BalloonLayoutData layoutData, boolean actions) {
        boolean hasTitle = notification.hasTitle();
        boolean hasContent = notification.hasContent();
        if (hasTitle && hasContent && actions) {
            return BalloonLayoutConfiguration.treeLines();
        }
        if (hasContent && NotificationsManagerImpl.calculateContentHeight(hasTitle || actions ? 1 : 2) < layoutData.fullHeight) {
            return BalloonLayoutConfiguration.treeLines();
        }
        return BalloonLayoutConfiguration.twoLines();
    }

    @NotNull
    public BalloonLayoutConfiguration replace(int topSpaceHeight, int bottomSpaceHeight) {
        return new BalloonLayoutConfiguration(this.iconPanelWidth, this.iconOffset, topSpaceHeight, this.titleContentSpaceHeight, this.contentActionsSpaceHeight, this.titleActionsSpaceHeight, bottomSpaceHeight, this.actionGap, null, 0, 0, 0);
    }

    @NotNull
    private static BalloonLayoutConfiguration twoLines() {
        return new BalloonLayoutConfiguration((Dimension)new JBDimension(10, 11), JBUI.scale((int)11), JBUI.scale((int)5), JBUI.scale((int)5), JBUI.scale((int)5), JBUI.scale((int)14));
    }

    @NotNull
    private static BalloonLayoutConfiguration treeLines() {
        return new BalloonLayoutConfiguration((Dimension)new JBDimension(10, 7), JBUI.scale((int)7), JBUI.scale((int)3), JBUI.scale((int)7), 0, JBUI.scale((int)8));
    }

    private BalloonLayoutConfiguration(@NotNull Dimension iconOffset, int topSpaceHeight, int titleContentSpaceHeight, int contentActionsSpaceHeight, int titleActionsSpaceHeight, int bottomSpaceHeight) {
        this(JBUI.scale((int)32), iconOffset, topSpaceHeight, titleContentSpaceHeight, contentActionsSpaceHeight, titleActionsSpaceHeight, bottomSpaceHeight, JBUI.scale((int)16), (Dimension)new JBDimension(8, 6), JBUI.scale((int)7), JBUI.scale((int)5), JBUI.scale((int)15));
    }

    private BalloonLayoutConfiguration(int iconPanelWidth, @NotNull Dimension iconOffset, int topSpaceHeight, int titleContentSpaceHeight, int contentActionsSpaceHeight, int titleActionsSpaceHeight, int bottomSpaceHeight, int actionGap, @Nullable Dimension rightActionsOffset, int afterGearSpace, int beforeCloseSpace, int beforeGearSpace) {
        this.iconPanelWidth = iconPanelWidth;
        this.iconOffset = iconOffset;
        this.topSpaceHeight = topSpaceHeight;
        this.titleContentSpaceHeight = titleContentSpaceHeight;
        this.contentActionsSpaceHeight = contentActionsSpaceHeight;
        this.titleActionsSpaceHeight = titleActionsSpaceHeight;
        this.bottomSpaceHeight = bottomSpaceHeight;
        this.actionGap = actionGap;
        if (rightActionsOffset == null) {
            this.rightActionsOffset = new Dimension();
            this.closeOffset = 0;
            this.gearCloseSpace = 0;
            this.allActionsOffset = 0;
            this.beforeGearSpace = 0;
        } else {
            this.rightActionsOffset = rightActionsOffset;
            this.closeOffset = beforeCloseSpace + AllIcons.Ide.Notification.Close.getIconWidth() + rightActionsOffset.width;
            this.gearCloseSpace = afterGearSpace + beforeCloseSpace;
            this.allActionsOffset = this.closeOffset + afterGearSpace + AllIcons.Ide.Notification.Gear.getIconWidth();
            this.beforeGearSpace = beforeGearSpace;
        }
    }

    static {
        int width;
        if (SystemInfo.isMac) {
            width = 360;
            RawStyleWidth = 240;
        } else if (SystemInfo.isLinux) {
            width = 410;
            RawStyleWidth = 270;
        } else {
            width = 330;
            RawStyleWidth = 205;
        }
        width += AllIcons.Ide.Shadow.Left.getIconWidth();
        RawWidth = width += AllIcons.Ide.Shadow.Right.getIconWidth();
    }
}

