/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.ColorChooser;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.ColorsIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ColorLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public static final ColorLineMarkerProvider INSTANCE = new ColorLineMarkerProvider();
    private final ElementColorProvider[] myExtensions = (ElementColorProvider[])ElementColorProvider.EP_NAME.getExtensions();

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        for (ElementColorProvider colorProvider : this.myExtensions) {
            Color color = colorProvider.getColorFrom(element);
            if (color == null) continue;
            MyInfo info = new MyInfo(element, color, colorProvider);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)"Choose color", null);
            return info;
        }
        return null;
    }

    public String getName() {
        return "Color preview";
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.Gutter.Colors;
    }

    private static class MyInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final Color myColor;

        MyInfo(@NotNull PsiElement element, Color color, ElementColorProvider colorProvider) {
            super(element, element.getTextRange(), (Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(12, color)), 11, (Function)FunctionUtil.nullConstant(), (e, elt) -> {
                if (!elt.isWritable()) {
                    return;
                }
                Editor editor = PsiUtilBase.findEditor((PsiElement)elt);
                assert (editor != null);
                Color c = ColorChooser.chooseColor((Project)editor.getProject(), (Component)editor.getComponent(), (String)"Choose Color", (Color)color, (boolean)true);
                if (c != null) {
                    WriteAction.run(() -> colorProvider.setColorTo(elt, c));
                }
            }, GutterIconRenderer.Alignment.LEFT);
            this.myColor = color;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            return info instanceof MyInfo;
        }

        public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
            return JBUI.scale((JBUI.JBIcon)new ColorsIcon(12, (Color[])infos.stream().map(_info -> ((MyInfo)_info).myColor).toArray(Color[]::new)));
        }

        @NotNull
        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
            return FunctionUtil.nullConstant();
        }
    }
}

