/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public class EditorNotificationsImpl
extends EditorNotifications {
    private static final ProjectExtensionPointName<EditorNotifications.Provider> EP_PROJECT = new ProjectExtensionPointName("com.intellij.editorNotificationProvider");
    private final Key<CancellablePromise<?>> CURRENT_UPDATE = Key.create((String)"EditorNotifications update");
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"EditorNotificationsImpl Pool");
    private final MergingUpdateQueue myUpdateMerger;
    @NotNull
    private final Project myProject;

    public EditorNotificationsImpl(@NotNull Project project) {
        this.myUpdateMerger = new MergingUpdateQueue("EditorNotifications update merger", 100, true, null, (Disposable)project);
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                EditorNotificationsImpl.this.updateNotifications(file2);
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void exitDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
    }

    public void updateNotifications(@NotNull VirtualFile file2) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed() || !file2.isValid()) {
                return;
            }
            CancellablePromise prev2 = (CancellablePromise)file2.getUserData(this.CURRENT_UPDATE);
            if (prev2 != null) {
                prev2.cancel();
            }
            CancellablePromise promise = ReadAction.nonBlocking(() -> this.calcNotificationUpdates(file2)).expireWhen(() -> !file2.isValid() || this.myProject.isDisposed()).finishOnUiThread(ModalityState.any(), updates -> {
                for (Runnable update : updates) {
                    update.run();
                }
            }).submit((Executor)ourExecutor);
            file2.putUserData(this.CURRENT_UPDATE, (Object)promise);
            promise.onProcessed(__ -> file2.putUserData(this.CURRENT_UPDATE, null));
        });
    }

    @NotNull
    private List<Runnable> calcNotificationUpdates(@NotNull VirtualFile file2) {
        List editors = ContainerUtil.filter((Object[])FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file2), editor -> !(editor instanceof TextEditor) || AsyncEditorLoader.isEditorLoaded(((TextEditor)editor).getEditor()));
        List providers = DumbService.getDumbAwareExtensions((Project)this.myProject, EP_PROJECT);
        SmartList updates = new SmartList();
        for (FileEditor editor2 : editors) {
            for (EditorNotifications.Provider provider : providers) {
                JComponent component = provider.createNotificationPanel(file2, editor2, this.myProject);
                updates.add(() -> this.updateNotification(editor2, (Key<? extends JComponent>)provider.getKey(), component));
            }
        }
        return updates;
    }

    private void updateNotification(@NotNull FileEditor editor, @NotNull Key<? extends JComponent> key, @Nullable JComponent component) {
        JComponent old = (JComponent)editor.getUserData(key);
        if (old != null) {
            FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor, old);
        }
        if (component != null) {
            FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor, component);
            Key<? extends JComponent> _key = key;
            editor.putUserData(_key, (Object)component);
        } else {
            editor.putUserData(key, null);
        }
    }

    public void updateAllNotifications() {
        this.myUpdateMerger.queue(new Update("update"){

            public void run() {
                for (VirtualFile file2 : FileEditorManager.getInstance((Project)EditorNotificationsImpl.this.myProject).getOpenFiles()) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }
        });
    }

    public static void completeAsyncTasks() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    public static class RefactoringListenerProvider
    implements RefactoringElementListenerProvider {
        @Nullable
        public RefactoringElementListener getListener(final @NotNull PsiElement element) {
            if (element instanceof PsiFile) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        VirtualFile vFile;
                        if (newElement instanceof PsiFile && (vFile = newElement.getContainingFile().getVirtualFile()) != null) {
                            EditorNotifications.getInstance((Project)element.getProject()).updateNotifications(vFile);
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        this.elementRenamedOrMoved(newElement);
                    }
                };
            }
            return null;
        }
    }
}

