/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorTextFieldRendererDocument;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorTextFieldCellRenderer
implements TableCellRenderer,
Disposable {
    private static final Key<SimpleRendererComponent> MY_PANEL_PROPERTY = Key.create((String)"EditorTextFieldCellRenderer.MyEditorPanel");
    private final Project myProject;
    private final FileType myFileType;
    private final boolean myInheritFontFromLaF;

    protected EditorTextFieldCellRenderer(@Nullable Project project, @Nullable FileType fileType, @NotNull Disposable parent) {
        this(project, fileType, true, parent);
    }

    private EditorTextFieldCellRenderer(@Nullable Project project, @Nullable FileType fileType, boolean inheritFontFromLaF, @NotNull Disposable parent) {
        this.myProject = project;
        this.myFileType = fileType;
        this.myInheritFontFromLaF = inheritFontFromLaF;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    protected abstract String getText(JTable var1, Object var2, int var3, int var4);

    @Nullable
    protected TextAttributes getTextAttributes(JTable table, Object value, int row2, int column) {
        return null;
    }

    @NotNull
    protected EditorColorsScheme getColorScheme(JTable table) {
        return this.getEditorPanel(table).getEditor().getColorsScheme();
    }

    protected void customizeEditor(@NotNull EditorEx editor, JTable table, Object value, boolean selected, int row2, int column) {
        String text = this.getText(table, value, row2, column);
        this.getEditorPanel(table).setText(text, this.getTextAttributes(table, value, row2, column), selected);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row2, int column) {
        RendererComponent panel2 = this.getEditorPanel(table);
        EditorEx editor = panel2.getEditor();
        editor.getColorsScheme().setEditorFontSize(table.getFont().getSize());
        editor.getColorsScheme().setColor(EditorColors.SELECTION_BACKGROUND_COLOR, table.getSelectionBackground());
        editor.getColorsScheme().setColor(EditorColors.SELECTION_FOREGROUND_COLOR, table.getSelectionForeground());
        editor.setBackgroundColor(selected ? table.getSelectionBackground() : table.getBackground());
        panel2.setSelected(!Comparing.equal((Object)editor.getBackgroundColor(), (Object)table.getBackground()));
        panel2.setBorder(null);
        this.customizeEditor(editor, table, value, selected, row2, column);
        return panel2;
    }

    @NotNull
    private RendererComponent getEditorPanel(JTable table) {
        RendererComponent panel2 = (RendererComponent)((Object)UIUtil.getClientProperty((Object)table, MY_PANEL_PROPERTY));
        if (panel2 != null) {
            DelegateColorScheme scheme2 = (DelegateColorScheme)panel2.getEditor().getColorsScheme();
            scheme2.setDelegate(EditorColorsUtil.getGlobalOrDefaultColorScheme());
            return panel2;
        }
        panel2 = this.createRendererComponent(this.myProject, this.myFileType, this.myInheritFontFromLaF);
        Disposer.register((Disposable)this, (Disposable)panel2);
        Disposer.register((Disposable)this, () -> UIUtil.putClientProperty((JComponent)table, MY_PANEL_PROPERTY, null));
        table.putClientProperty(MY_PANEL_PROPERTY, (Object)panel2);
        return panel2;
    }

    @NotNull
    protected RendererComponent createRendererComponent(@Nullable Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
        return new AbbreviatingRendererComponent(project, fileType, inheritFontFromLaF);
    }

    public void dispose() {
    }

    public static class AbbreviatingRendererComponent
    extends RendererComponent {
        private static final char ABBREVIATION_SUFFIX = '\u2026';
        private static final char RETURN_SYMBOL = '\u23ce';
        private final StringBuilder myDocumentTextBuilder = new StringBuilder();
        private Dimension myPreferredSize;
        private String myRawText;

        public AbbreviatingRendererComponent(Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            super(project, fileType, inheritFontFromLaF);
        }

        @Override
        public void setText(String text) {
            this.myRawText = text;
            this.myPreferredSize = null;
        }

        public Dimension getPreferredSize() {
            if (this.myPreferredSize == null) {
                int maxLineLength = 0;
                int linesCount = 0;
                LineTokenizer lt = new LineTokenizer((CharSequence)this.myRawText);
                while (!lt.atEnd()) {
                    maxLineLength = Math.max(maxLineLength, lt.getLength());
                    ++linesCount;
                    lt.advance();
                }
                FontMetrics fontMetrics = ((EditorImpl)this.getEditor()).getFontMetrics(this.myTextAttributes != null ? this.myTextAttributes.getFontType() : 0);
                int preferredHeight = this.getEditor().getLineHeight() * Math.max(1, linesCount);
                int preferredWidth = fontMetrics.charWidth('m') * maxLineLength;
                Insets insets = this.getInsets();
                if (insets != null) {
                    preferredHeight += insets.top + insets.bottom;
                    preferredWidth += insets.left + insets.right;
                }
                this.myPreferredSize = new Dimension(preferredWidth, preferredHeight);
            }
            return this.myPreferredSize;
        }

        protected void paintChildren(Graphics g) {
            this.updateText(g.getClipBounds());
            super.paintChildren(g);
        }

        private void updateText(Rectangle clip) {
            boolean singleLineMode;
            FontMetrics fontMetrics = ((EditorImpl)this.getEditor()).getFontMetrics(this.myTextAttributes != null ? this.myTextAttributes.getFontType() : 0);
            Insets insets = this.getInsets();
            int maxLineWidth = this.getWidth() - (insets != null ? insets.left + insets.right : 0);
            this.myDocumentTextBuilder.setLength(0);
            boolean bl = singleLineMode = (float)this.getHeight() / (float)this.getEditor().getLineHeight() < 1.1f;
            if (singleLineMode) {
                AbbreviatingRendererComponent.appendAbbreviated(this.myDocumentTextBuilder, this.myRawText, 0, this.myRawText.length(), fontMetrics, maxLineWidth, true);
            } else {
                int line;
                int lineHeight = this.getEditor().getLineHeight();
                int firstVisibleLine = clip.y / lineHeight;
                float visibleLinesCountFractional = (float)clip.height / (float)lineHeight;
                int linesToAppend = 1 + (int)visibleLinesCountFractional;
                LineTokenizer lt = new LineTokenizer((CharSequence)this.myRawText);
                for (line = 0; !lt.atEnd() && line < firstVisibleLine; ++line) {
                    this.myDocumentTextBuilder.append('\n');
                    lt.advance();
                }
                for (line = 0; !lt.atEnd() && line < linesToAppend; ++line) {
                    int start2 = lt.getOffset();
                    int end = start2 + lt.getLength();
                    AbbreviatingRendererComponent.appendAbbreviated(this.myDocumentTextBuilder, this.myRawText, start2, end, fontMetrics, maxLineWidth, false);
                    if (lt.getLineSeparatorLength() > 0) {
                        this.myDocumentTextBuilder.append('\n');
                    }
                    lt.advance();
                }
            }
            this.setTextToEditor(this.myDocumentTextBuilder.toString());
        }

        private static void appendAbbreviated(StringBuilder to, String text, int start2, int end, FontMetrics metrics, int maxWidth, boolean replaceLineTerminators) {
            int abbreviationLength = AbbreviatingRendererComponent.abbreviationLength(text, start2, end, metrics, maxWidth, replaceLineTerminators);
            if (!replaceLineTerminators) {
                to.append(text, start2, start2 + abbreviationLength);
            } else {
                CharSequenceSubSequence subSeq = new CharSequenceSubSequence((CharSequence)text, start2, start2 + abbreviationLength);
                LineTokenizer lt = new LineTokenizer((CharSequence)subSeq);
                while (!lt.atEnd()) {
                    to.append((CharSequence)subSeq, lt.getOffset(), lt.getOffset() + lt.getLength());
                    if (lt.getLineSeparatorLength() > 0) {
                        to.append('\u23ce');
                    }
                    lt.advance();
                }
            }
            if (abbreviationLength != end - start2) {
                to.append('\u2026');
            }
        }

        private static int abbreviationLength(String text, int start2, int end, FontMetrics metrics, int maxWidth, boolean replaceSeparators) {
            if (metrics.charWidth('m') * (end - start2) <= maxWidth) {
                return end - start2;
            }
            int abbrWidth = metrics.charWidth('\u2026');
            int abbrLength = 0;
            CharSequenceSubSequence subSeq = new CharSequenceSubSequence((CharSequence)text, start2, end);
            LineTokenizer lt = new LineTokenizer((CharSequence)subSeq);
            while (!lt.atEnd()) {
                int i = 0;
                while (i < lt.getLength()) {
                    if ((abbrWidth += metrics.charWidth(subSeq.charAt(lt.getOffset() + i))) >= maxWidth) {
                        return abbrLength;
                    }
                    ++i;
                    ++abbrLength;
                }
                if (replaceSeparators && lt.getLineSeparatorLength() != 0) {
                    if ((abbrWidth += metrics.charWidth('\u23ce')) >= maxWidth) {
                        return abbrLength;
                    }
                    abbrLength += lt.getLineSeparatorLength();
                }
                lt.advance();
            }
            return abbrLength;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleContextDelegate(super.getAccessibleContext()){

                    protected Container getDelegateParent() {
                        return this.getParent();
                    }

                    public String getAccessibleName() {
                        return myRawText;
                    }
                };
            }
            return this.accessibleContext;
        }
    }

    public static class SimpleRendererComponent
    extends RendererComponent
    implements Disposable {
        public SimpleRendererComponent(Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            super(project, fileType, inheritFontFromLaF);
        }

        @Override
        public void setText(String text) {
            this.setTextToEditor(text);
        }
    }

    public static abstract class RendererComponent
    extends CellRendererPanel
    implements Disposable {
        private final EditorEx myEditor;
        private final EditorTextField myTextField;
        TextAttributes myTextAttributes;
        private boolean mySelected;

        RendererComponent(Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            Pair<EditorTextField, EditorEx> pair = RendererComponent.createEditor(project, fileType, inheritFontFromLaF);
            this.myTextField = (EditorTextField)pair.first;
            this.myEditor = (EditorEx)pair.second;
            this.add(this.myEditor.getContentComponent());
        }

        public EditorEx getEditor() {
            return this.myEditor;
        }

        @NotNull
        private static Pair<EditorTextField, EditorEx> createEditor(Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            EditorTextField field = new EditorTextField(new EditorTextFieldRendererDocument(), project, fileType, false, false);
            field.setSupplementary(true);
            field.setFontInheritedFromLAF(inheritFontFromLaF);
            field.addNotify();
            EditorEx editor = (EditorEx)ObjectUtils.assertNotNull((Object)field.getEditor());
            editor.setRendererMode(true);
            editor.getSettings().setAnimatedScrolling(false);
            editor.setColorsScheme(editor.createBoundColorSchemeDelegate(null));
            editor.getSettings().setCaretRowShown(false);
            editor.getScrollPane().setBorder(null);
            return Pair.create((Object)field, (Object)editor);
        }

        public void setText(String text, @Nullable TextAttributes textAttributes, boolean selected) {
            this.myTextAttributes = textAttributes;
            this.mySelected = selected;
            this.setText(text);
        }

        public abstract void setText(String var1);

        public void setBackground(Color bg) {
            if (this.myEditor != null) {
                this.myEditor.setBackgroundColor(bg);
            }
            super.setBackground(bg);
        }

        public void dispose() {
            this.remove(this.myEditor.getContentComponent());
            this.myTextField.removeNotify();
        }

        void setTextToEditor(String text) {
            this.myEditor.getMarkupModel().removeAllHighlighters();
            this.myEditor.getDocument().setText(text);
            ((EditorImpl)this.myEditor).resetSizes();
            this.myEditor.getHighlighter().setText((CharSequence)text);
            if (this.myTextAttributes != null) {
                this.myEditor.getMarkupModel().addRangeHighlighter(0, this.myEditor.getDocument().getTextLength(), 3000, this.myTextAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
            ((EditorImpl)this.myEditor).setPaintSelection(this.mySelected);
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            selectionModel.setSelection(0, this.mySelected ? this.myEditor.getDocument().getTextLength() : 0);
        }
    }
}

